/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.integration.univariate.riemann.gaussian;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.integration.univariate.riemann.Integrator;
import dev.nm.analysis.integration.univariate.riemann.gaussian.rule.GaussianQuadratureRule;
import dev.nm.misc.ArgumentAssertion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GaussianQuadrature
implements Integrator {
    private final GaussianQuadratureRule enum;

    @Override
    public double getPrecision() {
        throw new UnsupportedOperationException("Gaussian quadrature rule is NOT an iterative method");
    }

    @Override
    public double integrate(UnivariateRealFunction f2, double a2, double b2) {
        ArgumentAssertion.assertTrue(this.enum.supportsInterval(a2, b2), "the rule does not support the interval (%f,%f)", a2, b2);
        double[] a3 = this.enum.getCoefficients();
        double[] a4 = this.enum.getEvaluationPoints();
        ArgumentAssertion.assertTrue(a3.length == a4.length, "the number of evaluation points does not match the number of coefficients", new Object[0]);
        double a5 = 0.0;
        for (int a6 = 0; a6 < a3.length; ++a6) {
            a5 += a3[a6] * (f2.evaluate(a4[a6]) / this.enum.getWeighting(a4[a6]));
        }
        return a5;
    }

    public GaussianQuadrature(GaussianQuadratureRule rule) {
        this.enum = rule;
    }
}

