/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial.root;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.polynomial.root.PolyRootSolver;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.complex.Complex;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CubicRoot
implements PolyRootSolver {
    private static final double enum = Math.sqrt(3.0) / 2.0;

    public List<Number> solve(Polynomial polynomial) {
        ArgumentAssertion.assertEqual(polynomial.degree(), 3, "polynomial degree");
        ArrayList<Number> a2 = new ArrayList<Number>();
        double[] a3 = polynomial.getCoefficients();
        double a4 = a3[0];
        double a5 = a3[1];
        double a6 = a3[2];
        double a7 = a3[3];
        double a8 = a4 * a4;
        double a9 = a5 * a5;
        double a10 = (3.0 * a4 * a6 - a9) / (9.0 * a8);
        double a11 = (9.0 * a4 * a5 * a6 - 27.0 * a8 * a7 - 2.0 * a9 * a5) / (54.0 * a8 * a4);
        double a12 = a5 / (3.0 * a4);
        double a13 = a10 * a10 * a10;
        double a14 = a13 + a11 * a11;
        if (a14 >= 0.0) {
            double a15 = Math.cbrt(a11 + Math.sqrt(a14));
            double a16 = Math.cbrt(a11 - Math.sqrt(a14));
            double a17 = a15 + a16;
            double a18 = a15 - a16;
            double a19 = -a17 / 2.0 - a12;
            double a20 = a18 * enum;
            a2.add(new Double(a17 - a12));
            a2.add(new Complex(a19, a20));
            a2.add(new Complex(a19, -a20));
        } else {
            double a21 = Math.sqrt(-a13);
            double a22 = Math.acos(a11 / a21);
            double a23 = Math.cbrt(a21);
            double a24 = a22 / 3.0;
            Complex a25 = Complex.fromPolar(a23, a24);
            Complex a26 = Complex.fromPolar(a23, -a24);
            Complex a27 = a25.add(a26);
            Complex a28 = a25.minus(a26);
            Complex a29 = a27.divide(new Complex(-2.0, 0.0)).minus(new Complex(a12, 0.0));
            Complex a30 = a28.multiply(new Complex(0.0, enum));
            a2.add(a27.minus(new Complex(a12, 0.0)).real());
            a2.add(a29.add(a30).real());
            a2.add(a29.minus(a30).real());
        }
        return a2;
    }
}

