/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation.multivariate;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.Constants;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateFiniteDifference
extends AbstractRealScalarFunction {
    private final int[] goto;
    private final RealScalarFunction enum;

    public MultivariateFiniteDifference(RealScalarFunction f2, int[] varidx) {
        super(f2.dimensionOfDomain());
        this.enum = f2;
        for (int a2 = 0; a2 < varidx.length; ++a2) {
            if (varidx[a2] >= 1 && varidx[a2] <= f2.dimensionOfDomain()) continue;
            throw new IllegalArgumentException("invalid variable specification; order specifiies variable indices");
        }
        this.goto = Arrays.copyOf(varidx, varidx.length);
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = Math.pow(Constants.MACH_EPS, 1.0 / (double)(this.goto.length + 1)) * Math.max(0.1, x.norm());
        return this.evaluate(x, a2);
    }

    private double do(int a2, double a3, Vector a4) {
        MultivariateFiniteDifference a5;
        DenseVector a6 = new DenseVector(a4);
        if (a2 == 1) {
            int a7 = a5.goto[0];
            a6.set(a7, a4.get(a7) + a3);
            double a8 = (Double)a5.enum.evaluate(a6);
            a6.set(a7, a6.get(a7) - 2.0 * a3);
            double a9 = (Double)a5.enum.evaluate(a6);
            double a10 = (a8 - a9) / 2.0 / a3;
            return a10;
        }
        int a11 = a5.goto[a2 - 1];
        a6.set(a11, a4.get(a11) + a3);
        double a12 = a5.do(a2 - 1, a3, a6);
        a6.set(a11, a6.get(a11) - 2.0 * a3);
        double a13 = a5.do(a2 - 1, a3, a6);
        double a14 = (a12 - a13) / 2.0 / a3;
        return a14;
    }

    public double evaluate(Vector x, double h2) {
        double a2 = this.do(this.goto.length, h2, x);
        return a2;
    }
}

