/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.elliptic.dim2;

import dev.nm.analysis.differentialequation.UnsatisfiableErrorCriterionException;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionGrid2D;
import dev.nm.analysis.differentialequation.pde.finitedifference.elliptic.dim2.PoissonEquation2D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IterativeCentralDifference
implements PDESolver {
    private final int goto;
    private final double enum;

    static {
        Package.validate("NMDEV_OPDE");
    }

    public PDESolutionGrid2D solve(PoissonEquation2D pde, final int m2, final int n) {
        int a2;
        int a32;
        ArgumentAssertion.assertGreaterThan(m2, 1, "the number of x-axis grid points");
        ArgumentAssertion.assertGreaterThan(n, 1, "the number of y-axis grid points");
        final double[][] a4 = new double[m2 + 2][n + 2];
        final double[] a5 = DoubleUtils.seq(0.0, pde.a(), m2 + 2);
        final double[] a6 = DoubleUtils.seq(0.0, pde.b(), n + 2);
        double a7 = 0.0;
        for (int a32 : new int[]{0, m2 + 1}) {
            for (a2 = 0; a2 < n + 2; ++a2) {
                a4[a32][a2] = pde.g(a5[a32], a6[a2]);
                a7 += a4[a32][a2];
            }
        }
        for (int a8 = 1; a8 < m2 + 1; ++a8) {
            int[] nArray = new int[]{0, n + 1};
            int n2 = nArray.length;
            for (a32 = 0; a32 < n2; ++a32) {
                a2 = nArray[a32];
                a4[a8][a2] = pde.g(a5[a8], a6[a2]);
                a7 += a4[a8][a2];
            }
        }
        double a9 = a7 / (2.0 * (double)(m2 + n) - 4.0);
        for (int a10 = 1; a10 < m2 + 1; ++a10) {
            for (a32 = 1; a32 < n + 1; ++a32) {
                a4[a10][a32] = a9;
            }
        }
        double a11 = a5[1];
        double a12 = a6[1];
        double a13 = a11 * a11;
        double a14 = a12 * a12;
        double a15 = a13 / a14;
        double a16 = (Math.cos(Math.PI / (double)n) + a15 * Math.cos(Math.PI / (double)m2)) / (1.0 + a15);
        double a17 = 2.0 / (1.0 + Math.sqrt(1.0 - a16 * a16));
        boolean a18 = false;
        for (int a19 = 0; a19 < this.goto; ++a19) {
            double a20 = 0.0;
            for (int a21 = 1; a21 < m2 + 1; ++a21) {
                for (int a22 = 1; a22 < n + 1; ++a22) {
                    double a23 = a14 * (a4[a21 + 1][a22] + a4[a21 - 1][a22]);
                    double a24 = a13 * (a4[a21][a22 + 1] + a4[a21][a22 - 1]);
                    double a25 = a13 * a14 * pde.f((double)a21 * a11, (double)a22 * a12);
                    double a26 = 2.0 * (a13 + a14);
                    double a27 = (a23 + a24 - a25) / a26;
                    double a28 = a4[a21][a22];
                    a4[a21][a22] = (1.0 - a17) * a4[a21][a22] + a17 * a27;
                    a20 = Math.max(a20, Math.abs(a4[a21][a22] - a28));
                }
            }
            if (!(a20 < this.enum)) continue;
            a18 = true;
            break;
        }
        if (!a18) {
            throw new UnsatisfiableErrorCriterionException("failed to converge to the given bound within the maximum number of iterations");
        }
        return new PDESolutionGrid2D(){
            {
                1 a3;
            }

            @Override
            public double x(int k2) {
                ArgumentAssertion.assertRange(k2, 0, m2 + 1, "k");
                return a5[k2];
            }

            @Override
            public double y(int j2) {
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a6[j2];
            }

            @Override
            public int m() {
                return m2;
            }

            @Override
            public int n() {
                return n;
            }

            @Override
            public double u(int k2, int j2) {
                ArgumentAssertion.assertRange(k2, 0, m2 + 1, "k");
                ArgumentAssertion.assertRange(j2, 0, n + 1, "j");
                return a4[k2][j2];
            }
        };
    }

    public IterativeCentralDifference(double errorBound, int maxIterations) {
        this.enum = errorBound;
        this.goto = maxIterations;
    }
}

