/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.problem;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.AbstractRealVectorFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ODE1stOrder {
    private final double void;
    private final Vector class;
    private final double goto;
    private final DerivativeFunction enum;

    public static DerivativeFunction convertToDerivativeFunction(final RealVectorFunction F2, final int dimension) {
        ArgumentAssertion.assertTrue(F2.dimensionOfDomain() == dimension + 1, "dimension of domain of F must match the size of y + 1", new Object[0]);
        ArgumentAssertion.assertTrue(F2.dimensionOfRange() == dimension, "dimension of range of F must match the size of y", new Object[0]);
        return new DerivativeFunction(){

            @Override
            public int dimension() {
                return dimension;
            }

            @Override
            public Vector evaluate(double x, Vector y) {
                double[] a2 = DoubleUtils.concat({x}, y.toArray());
                return (Vector)F2.evaluate(new DenseVector(a2));
            }
            {
                3 a2;
            }
        };
    }

    public double x0() {
        return this.goto;
    }

    public ODE1stOrder(RealScalarFunction[] Y, double[] y0, double x0, double x1) {
        this(ODE1stOrder.do(Y), (Vector)new DenseVector(y0), x0, x1);
    }

    public double x1() {
        return this.void;
    }

    public int dimension() {
        return this.class.size();
    }

    public Vector y0() {
        return this.class;
    }

    private static RealVectorFunction do(final RealScalarFunction a2) {
        final int a3 = a2.dimensionOfDomain() - 1;
        AbstractRealVectorFunction a4 = new AbstractRealVectorFunction(a3 + 1, a3){

            @Override
            public Vector evaluate(Vector v) {
                double[] a22 = new double[a3];
                for (int a32 = 0; a32 < a3 - 1; ++a32) {
                    a22[a32] = v.get(a32 + 3);
                }
                a22[a3 - 1] = (Double)a2.evaluate(v);
                return new DenseVector(a22);
            }
            {
                2 a4;
                super(a22, a32);
            }
        };
        return a4;
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    public ODE1stOrder(ODE ode) {
        this(ODE1stOrder.do(ode.F()), ODE1stOrder.do(ode), ode.x0(), ode.x1());
    }

    public DerivativeFunction dy() {
        return this.enum;
    }

    private static RealVectorFunction do(final RealScalarFunction[] a2) {
        int a3 = a2[0].dimensionOfDomain() - 1;
        for (int a4 = 0; a4 < a2.length; ++a4) {
            ArgumentAssertion.assertTrue(a2[a4].dimensionOfDomain() == a3 + 1, "all differentials must of the same order and have the same dimension", new Object[0]);
        }
        return new AbstractRealVectorFunction(a2.length + 1, a2.length){

            @Override
            public Vector evaluate(Vector x) {
                double[] a22 = new double[a2.length];
                for (int a3 = 0; a3 < a22.length; ++a3) {
                    a22[a3] = (Double)a2[a3].evaluate(x);
                }
                return new DenseVector(a22);
            }
            {
                1 a4;
                super(a22, a3);
            }
        };
    }

    public ODE1stOrder(DerivativeFunction dy, Vector y0, double x0, double x1) {
        this.enum = dy;
        this.class = new ImmutableVector(y0.deepCopy());
        this.goto = x0;
        this.void = x1;
    }

    private static Vector do(ODE a2) {
        int a3 = a2.F().dimensionOfDomain() - 1;
        double[] a4 = new double[a3];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = a2.y0(a5);
        }
        return new DenseVector(a4);
    }

    public ODE1stOrder(RealVectorFunction F2, Vector y0, double x0, double x1) {
        this(ODE1stOrder.convertToDerivativeFunction(F2, y0.size()), y0, x0, x1);
    }
}

