/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit.interpolation;

import dev.nm.analysis.curvefit.interpolation.OnlineInterpolator;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.StepFunction;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.PartialFunction;
import dev.nm.misc.license.Package;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearInterpolator
extends AbstractUnivariateRealFunction
implements OnlineInterpolator {
    private double[] goto;
    private double[] enum;

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double evaluate(double u) {
        if (u < this.enum[0]) {
            throw new RuntimeException(String.format("cannot interpolate smaller than %f", this.enum[0]));
        }
        if (u > this.enum[this.enum.length - 1]) {
            throw new RuntimeException(String.format("cannot interpolate bigger than %f", this.enum[this.enum.length - 1]));
        }
        int a2 = Arrays.binarySearch(this.enum, u);
        if (a2 >= 0) {
            return this.goto[a2];
        }
        int a3 = -(a2 + 1);
        if (a3 == this.enum.length - 1) {
            --a3;
        }
        int a4 = a3 + 1;
        double a5 = FunctionOps.linearInterpolate(u, this.enum[a3], this.goto[a3], this.enum[a4], this.goto[a4]);
        return a5;
    }

    @Override
    public void addData(OrderedPairs f2) {
        StepFunction a2 = new StepFunction(new PartialFunction(this.enum, this.goto));
        a2.add(f2);
        this.enum = a2.x();
        this.goto = a2.y();
    }

    public LinearInterpolator(OrderedPairs f2) {
        this.enum = f2.x();
        this.goto = f2.y();
    }
}

