/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.vector.doubles.dense;

import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.number.Real;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.BinomialRNG;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.normal.RandomStandardNormalGenerator;

public class VectorMathOperation {
    public static Vector rbinom(int n, int nTrials, Vector p, RandomLongGenerator uniform) {
        assert (n == p.size());
        DenseVector a2 = new DenseVector(n);
        for (int a3 = 1; a3 <= n; ++a3) {
            a2.set(a3, new BinomialRNG(nTrials, p.get(a3), uniform).nextDouble());
        }
        return a2;
    }

    public DenseVector add(Vector v1, double c2) {
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) + c2);
        }
        return a3;
    }

    public static Vector rnorm(int n) {
        return VectorMathOperation.rnorm(n, RNGUtils.RNORM);
    }

    public static Vector sqrt(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return Math.sqrt(x);
            }
            {
                1 a2;
            }
        });
    }

    public double norm(Vector v1) {
        return this.norm(v1, 2.0);
    }

    public static Vector squared(Vector v) {
        return v.multiply(v);
    }

    public double angle(Vector v1, Vector v2) {
        double a2 = this.innerProduct(v1, v2);
        a2 /= v1.norm();
        a2 /= v2.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    public double innerProduct(Vector v1, Vector v2) {
        MatrixPropertyUtils.throwIfNotEqualSize(v1, v2);
        int a2 = v1.size();
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3 += v1.get(a4) * v2.get(a4);
        }
        return a3;
    }

    public DenseVector scaled(Vector v1, Real c2) {
        return this.scaled(v1, c2.doubleValue());
    }

    public double norm(Vector v1, double p) {
        double[] a2 = new double[v1.size()];
        for (int a3 = 0; a3 < v1.size(); ++a3) {
            a2[a3] = v1.get(a3 + 1);
        }
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(a2));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(a2));
        }
        double a4 = 0.0;
        for (int a5 = 0; a5 < v1.size(); ++a5) {
            a4 += Math.pow(a2[a5], p);
        }
        a4 = Math.pow(a4, 1.0 / p);
        return a4;
    }

    public static Vector rnorm(int n, RandomStandardNormalGenerator z) {
        DenseVector a2 = new DenseVector(n);
        for (int a3 = 1; a3 <= n; ++a3) {
            a2.set(a3, z.nextDouble());
        }
        return a2;
    }

    public DenseVector scaled(Vector v1, double c2) {
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, c2 * v1.get(a4));
        }
        return a3;
    }

    public DenseVector minus(Vector v1, Vector v2) {
        MatrixPropertyUtils.throwIfNotEqualSize(v1, v2);
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) - v2.get(a4));
        }
        return a3;
    }

    public DenseVector opposite(Vector v1) {
        return this.scaled(v1, -1.0);
    }

    public static Vector exp(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                5 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.exp(x);
            }
        });
    }

    public static Vector abs(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                2 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.abs(x);
            }
        });
    }

    public DenseVector multiply(Vector v1, Vector v2) {
        MatrixPropertyUtils.throwIfNotEqualSize(v1, v2);
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) * v2.get(a4));
        }
        return a3;
    }

    public DenseVector pow(Vector v1, double c2) {
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, Math.pow(v1.get(a4), c2));
        }
        return a3;
    }

    public static Vector sin(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                3 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.sin(x);
            }
        });
    }

    public DenseVector divide(Vector v1, Vector v2) {
        MatrixPropertyUtils.throwIfNotEqualSize(v1, v2);
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) / v2.get(a4));
        }
        return a3;
    }

    public static double sum(Vector v) {
        double a2 = 0.0;
        for (int a3 = 1; a3 <= v.size(); ++a3) {
            a2 += v.get(a3);
        }
        return a2;
    }

    public static Vector cos(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                4 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.cos(x);
            }
        });
    }

    public DenseVector add(Vector v1, Vector v2) {
        MatrixPropertyUtils.throwIfNotEqualSize(v1, v2);
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) + v2.get(a4));
        }
        return a3;
    }

    public static Vector log(Vector v) {
        return VectorFactory.foreach(v, (UnivariateRealFunction)new AbstractUnivariateRealFunction(){
            {
                6 a2;
            }

            @Override
            public double evaluate(double x) {
                return Math.log(x);
            }
        });
    }

    public static Vector rbinom(int n, int nTrials, Vector p) {
        Vector a2 = VectorMathOperation.rbinom(n, nTrials, p, RNGUtils.UNIFORM);
        return a2;
    }

    public DenseVector minus(Vector v1, double c2) {
        int a2 = v1.size();
        DenseVector a3 = new DenseVector(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            a3.set(a4, v1.get(a4) - c2);
        }
        return a3;
    }
}

