/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.vector.doubles.dense;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.VectorMathOperation;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DenseVector
implements Vector {
    private double[] class;
    private final int goto;
    private static final VectorMathOperation enum;

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof DenseVector) {
            return this.minus((DenseVector)that);
        }
        return enum.minus((Vector)this, that);
    }

    @Override
    public double innerProduct(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a2 = FunctionOps.dotProduct(this.class, that.class);
        return a2;
    }

    @Override
    public DenseVector add(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.goto);
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2.class[a3] = this.class[a3] + that.class[a3];
        }
        return a2;
    }

    public DenseVector(double ... data) {
        this.goto = data.length;
        this.class = data;
    }

    public DenseVector(int length, double value) {
        this.goto = length;
        this.class = new double[this.goto];
        for (int a2 = 0; a2 < this.class.length; ++a2) {
            this.class[a2] = value;
        }
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof DenseVector) {
            return this.add((DenseVector)that);
        }
        return enum.add((Vector)this, that);
    }

    @Override
    public void set(int i2, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i2);
        this.class[i2 - 1] = value;
    }

    @Override
    public DenseVector add(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.class, new AbstractUnivariateRealFunction(){
            {
                1 a3;
            }

            @Override
            public double evaluate(double x) {
                return x + scalar;
            }
        });
        return new DenseVector(a2);
    }

    public DenseVector(int[] data) {
        this.goto = data.length;
        this.class = new double[data.length];
        for (int a2 = 0; a2 < data.length; ++a2) {
            this.class[a2] = data[a2];
        }
    }

    @Override
    public double[] toArray() {
        double[] a2 = Arrays.copyOf(this.class, this.class.length);
        return a2;
    }

    @Override
    public int size() {
        return this.goto;
    }

    @Override
    public double angle(Vector that) {
        return enum.angle(this, that);
    }

    @Override
    public DenseVector minus(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        DenseVector a2 = new DenseVector(this.goto);
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2.class[a3] = this.class[a3] - that.class[a3];
        }
        return a2;
    }

    @Override
    public Vector divide(Vector that) {
        if (that instanceof DenseVector) {
            return this.divide((DenseVector)that);
        }
        return enum.divide(this, that);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector a2 = (Vector)obj;
        return MatrixPropertyUtils.areEqual(this, a2, 0.0);
    }

    public DenseVector divide(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.goto];
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2[a3] = this.get(a3 + 1) / that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2 += Math.pow(Math.abs(this.class[a3]), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    @Override
    public DenseVector deepCopy() {
        return new DenseVector(this);
    }

    public DenseVector(Vector v) {
        this.goto = v.size();
        this.class = v.toArray();
    }

    @Override
    public DenseVector pow(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.class, new AbstractUnivariateRealFunction(){
            {
                3 a3;
            }

            @Override
            public double evaluate(double x) {
                return Math.pow(x, scalar);
            }
        });
        return new DenseVector(a2);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("[");
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2.append(String.format("%f, ", this.class[a3]));
        }
        a2.setCharAt(a2.length() - 2, ']');
        return a2.toString();
    }

    public DenseVector(Collection<? extends Number> data) {
        this.goto = data.size();
        this.class = new double[this.goto];
        Iterator<? extends Number> a2 = data.iterator();
        for (int a3 = 0; a3 < this.goto; ++a3) {
            this.class[a3] = a2.next().doubleValue();
        }
    }

    @Override
    public DenseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    public DenseVector(DenseVector vector) {
        this.goto = vector.goto;
        this.class = Arrays.copyOf(vector.class, this.goto);
    }

    static {
        Package.validate("NMDEV_BASIC");
        enum = new VectorMathOperation();
    }

    public DenseVector multiply(DenseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double[] a2 = new double[this.goto];
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2[a3] = this.get(a3 + 1) * that.get(a3 + 1);
        }
        return new DenseVector(a2);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 19 * a2 + this.goto;
        a2 = 19 * a2 + Arrays.hashCode(this.class);
        return a2;
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof DenseVector) {
            return this.innerProduct((DenseVector)that);
        }
        return enum.innerProduct(this, that);
    }

    @Override
    public double get(int i2) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, i2);
        return this.class[i2 - 1];
    }

    public DenseVector(int length) {
        this.goto = length;
        this.class = new double[this.goto];
    }

    public DenseVector(List<Double> data) {
        this.goto = data.size();
        this.class = new double[data.size()];
        for (int a2 = 0; a2 < this.class.length; ++a2) {
            this.class[a2] = data.get(a2);
        }
    }

    public DenseVector(Double[] data) {
        this.goto = data.length;
        this.class = new double[data.length];
        for (int a2 = 0; a2 < this.class.length; ++a2) {
            this.class[a2] = data[a2];
        }
    }

    @Override
    public Vector multiply(Vector that) {
        if (that instanceof DenseVector) {
            return this.multiply((DenseVector)that);
        }
        return enum.multiply(this, that);
    }

    public void set(int from, DenseVector replacement) {
        if (from + replacement.goto - 1 > this.goto) {
            throw new IllegalArgumentException("the replacement vector length starting from 'from' exceeds the original vector length");
        }
        int a2 = from;
        for (int a3 = 1; a3 <= replacement.goto; ++a3) {
            this.set(a2, replacement.get(a3));
            ++a2;
        }
    }

    @Override
    public DenseVector ZERO() {
        return new DenseVector(this.goto);
    }

    @Override
    public DenseVector opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public DenseVector minus(final double scalar) {
        double[] a2 = DoubleUtils.foreach(this.class, new AbstractUnivariateRealFunction(){
            {
                2 a3;
            }

            @Override
            public double evaluate(double x) {
                return x - scalar;
            }
        });
        return new DenseVector(a2);
    }

    @Override
    public DenseVector scaled(double c2) {
        DenseVector a2 = new DenseVector(this.goto);
        for (int a3 = 0; a3 < this.goto; ++a3) {
            a2.class[a3] = this.class[a3] * c2;
        }
        return a2;
    }

    public DenseVector(Matrix A2) {
        if (A2.nCols() == 1) {
            this.class = A2.getColumn(1).toArray();
            this.goto = this.class.length;
            return;
        }
        if (A2.nRows() == 1) {
            this.class = A2.getRow(1).toArray();
            this.goto = this.class.length;
            return;
        }
        throw new IllegalArgumentException("A must be a column or row matrix");
    }
}

