/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation.householder;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.ColumnBindMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HouseholderReflection {
    private Matrix void = null;
    private final Vector class;
    private static final int goto = 2500;
    private static final int enum = 400;

    private static Matrix case(List<HouseholderReflection> a2, int a3, int a4) {
        Matrix a5 = MatrixFactory.identity(a3, a4);
        for (HouseholderReflection a6 : a2) {
            a5 = a6.reflect(a5);
        }
        return a5;
    }

    private void short(final Vector[] a2, int a3, int a4) {
        HouseholderReflection a5;
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(a3, a4 + 1, new LoopBody(){

                @Override
                public void run(int i2) throws Exception {
                    a2[i2] = HouseholderReflection.this.reflect(a2[i2]);
                }
                {
                    1 a3;
                }
            });
        }
        catch (MultipleExecutionException a6) {
            a5.do(a2, a3, a4);
        }
    }

    public static Matrix product(HouseholderReflection[] Hs, int from, int to, int nRows, int nCols) {
        List<HouseholderReflection> a2 = HouseholderReflection.do(Hs, from, to);
        if (a2.isEmpty()) {
            return MatrixFactory.identity(nRows, nCols);
        }
        return HouseholderReflection.do(a2, nRows, nCols);
    }

    private void do(Vector[] a2, int a3, int a4) {
        for (int a5 = a3; a5 <= a4; ++a5) {
            HouseholderReflection a6;
            a2[a5] = a6.reflect(a2[a5]);
        }
    }

    private static void short(final List<HouseholderReflection> a2, final Vector[] a3) {
        try {
            ParallelExecutorInstanceHolder.enum.forLoop(0, a3.length, new LoopBody(){
                {
                    2 a22;
                }

                @Override
                public void run(int k2) throws Exception {
                    a3[k2] = HouseholderReflection.do((List<HouseholderReflection>)a2, a3[k2]);
                }
            });
        }
        catch (Exception a4) {
            HouseholderReflection.do(a2, a3);
        }
    }

    public static Matrix product(HouseholderReflection[] Hs, int from, int to) {
        int a2 = Hs[from].definingVector().size();
        return HouseholderReflection.product(Hs, from, to, a2, a2);
    }

    private static void do(List<HouseholderReflection> a2, Vector[] a3) {
        for (int a4 = 0; a4 < a3.length; ++a4) {
            a3[a4] = HouseholderReflection.do(a2, a3[a4]);
        }
    }

    private static Matrix short(List<HouseholderReflection> a2, int a3, int a4) {
        Vector[] a5 = new Vector[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            DenseVector a7 = new DenseVector(a3);
            a7.set(a6 + 1, 1.0);
            a5[a6] = a7;
        }
        if (HouseholderReflection.do(a3 * a4)) {
            HouseholderReflection.short(a2, a5);
        } else {
            HouseholderReflection.do(a2, a5);
        }
        Matrix a8 = MatrixFactory.cbind(a5);
        return a8;
    }

    public Matrix reflectRows(Matrix A2) {
        Vector[] a2 = MatrixUtils.toRows(A2);
        this.reflectVectors(a2, 0, A2.nRows() - 1);
        return MatrixFactory.rbind(a2);
    }

    public HouseholderReflection(Vector v) {
        double a2 = v.norm();
        this.class = DoubleUtils.isZero(a2, 0.0) ? new SparseVector(v.size()) : v.scaled(1.0 / a2);
    }

    public Vector definingVector() {
        return new ImmutableVector(this.class);
    }

    public Vector reflect(Vector x) {
        Vector a2 = this.class.scaled(-2.0 * this.class.innerProduct(x)).add(x);
        return a2;
    }

    public void reflectVectors(Vector[] vectors, int startIndex, int endIndex) {
        if (startIndex > endIndex) {
            return;
        }
        if (HouseholderReflection.do(this.class.size() * (endIndex - startIndex + 1))) {
            this.short(vectors, startIndex, endIndex);
        } else {
            this.do(vectors, startIndex, endIndex);
        }
    }

    private static Matrix do(List<HouseholderReflection> a2, int a3, int a4) {
        int a5 = Integer.MIN_VALUE;
        for (HouseholderReflection a6 : a2) {
            int a7 = a6.class.size();
            if (a5 >= a7) continue;
            a5 = a7;
        }
        if (a5 * a5 > 400) {
            return HouseholderReflection.short(a2, a3, a4);
        }
        return HouseholderReflection.case(a2, a3, a4);
    }

    public Matrix H() {
        if (this.void == null) {
            Vector a2 = this.definingVector();
            int a3 = a2.size();
            Matrix a4 = MatrixFactory.identity(a3, a3);
            DenseMatrix a5 = new DenseMatrix(a2.toArray(), a2.size(), 1);
            this.void = a4.minus(a5.multiply(a5.t()).scaled(2.0));
        }
        return this.void;
    }

    private static boolean do(int a2) {
        return a2 >= 2500;
    }

    public HouseholderReflection(HouseholderContext ctx) {
        this(ctx.v, ctx.beta, ctx.lambda);
    }

    private static Vector do(List<HouseholderReflection> a2, Vector a3) {
        Vector a4 = a3;
        for (HouseholderReflection a5 : a2) {
            a4 = a5.reflect(a4);
        }
        return a4;
    }

    public HouseholderReflection(Vector v, double beta, double lambda) {
        if (lambda == 0.0) {
            this.class = v;
        } else {
            double a2 = Math.sqrt(beta / 2.0);
            this.class = v.scaled(a2);
        }
    }

    public Matrix reflectColumns(Matrix A2) {
        Vector[] a2 = MatrixUtils.toColumns(A2);
        this.reflectVectors(a2, 0, A2.nCols() - 1);
        return new ColumnBindMatrix(a2);
    }

    public Matrix rightReflect(Matrix A2) {
        int a2 = A2.nRows() * A2.nCols();
        if (a2 > 400) {
            return this.reflectRows(A2);
        }
        return A2.multiply(this.H());
    }

    public Matrix reflect(Matrix A2) {
        int a2 = A2.nRows() * A2.nCols();
        if (a2 > 400) {
            return this.reflectColumns(A2);
        }
        return this.H().multiply(A2);
    }

    private static List<HouseholderReflection> do(HouseholderReflection[] a2, int a3, int a4) {
        int[] a5 = DoubleUtils.seq(a4, a3);
        ArrayList<HouseholderReflection> a6 = new ArrayList<HouseholderReflection>(a2.length);
        for (int a7 : a5) {
            if (a2[a7] == null) continue;
            a6.add(a2[a7]);
        }
        return a6;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ParallelExecutorInstanceHolder {
        private static final ParallelExecutor enum = new ParallelExecutor(HouseholderReflection.class.getSimpleName());

        private ParallelExecutorInstanceHolder() {
            ParallelExecutorInstanceHolder a2;
        }
    }
}

