/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixTable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.rn2r1.AbstractBivariateRealFunction;
import dev.nm.analysis.function.rn2r1.BivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.Collections;

public class MatrixUtils {
    public static Matrix deRowMean(Matrix A2) {
        Vector a2 = MatrixUtils.rowMeanVector(A2);
        return A2.minus(MatrixFactory.cbind(Collections.nCopies(A2.nCols(), a2)));
    }

    public static Matrix elementMultiply(Matrix A1, Matrix A2) {
        AbstractBivariateRealFunction a2 = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double a1, double a2) {
                double a3 = a1 * a2;
                return a3;
            }
            {
                1 a2;
            }
        };
        Matrix a3 = MatrixUtils.elementOperation(A1, A2, a2);
        return a3;
    }

    public static double[] colSums(MatrixTable A2) {
        double[] a2 = new double[A2.nCols()];
        for (int a3 = 1; a3 <= A2.nCols(); ++a3) {
            a2[a3 - 1] = 0.0;
            for (int a4 = 1; a4 <= A2.nRows(); ++a4) {
                int n = a3 - 1;
                a2[n] = a2[n] + A2.get(a4, a3);
            }
        }
        return a2;
    }

    public static Matrix deColumnMean(Matrix A2) {
        Vector a2 = MatrixUtils.colMeanVector(A2);
        return A2.minus(MatrixFactory.rbind(Collections.nCopies(A2.nRows(), a2)));
    }

    public static Vector[] toRows(Matrix A2) {
        Vector[] a2 = new Vector[A2.nRows()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = A2.getRow(a3 + 1);
        }
        return a2;
    }

    public static Vector rowSumVector(MatrixTable A2) {
        return new DenseVector(MatrixUtils.rowSums(A2));
    }

    public static double[] colMeans(MatrixTable A2) {
        return DoubleArrayMath.scale(MatrixUtils.colSums(A2), 1.0 / (double)A2.nRows());
    }

    public static double sum(MatrixTable A2) {
        double a2 = 0.0;
        int a3 = A2.nRows();
        int a4 = A2.nCols();
        for (int a5 = 1; a5 <= a3; ++a5) {
            for (int a6 = 1; a6 <= a4; ++a6) {
                a2 += A2.get(a5, a6);
            }
        }
        return a2;
    }

    public static Matrix elementOperation(Matrix A1, Matrix A2, BivariateRealFunction f2) {
        ArgumentAssertion.assertTrue(A1.nRows() == A2.nRows(), "matrix (row) dimensions must match", new Object[0]);
        ArgumentAssertion.assertTrue(A1.nCols() == A2.nCols(), "matrix (column) dimensions must match", new Object[0]);
        int a2 = A1.nRows();
        int a3 = A1.nCols();
        DenseMatrix a4 = new DenseMatrix(a2, a3);
        for (int a5 = 1; a5 <= a2; ++a5) {
            for (int a6 = 1; a6 <= a3; ++a6) {
                double a7 = A1.get(a5, a6);
                double a8 = A2.get(a5, a6);
                double a9 = f2.evaluate(a7, a8);
                a4.set(a5, a6, a9);
            }
        }
        return a4;
    }

    public static double[] to1DArray(MatrixTable A2) {
        int a2 = A2.nRows();
        int a3 = A2.nCols();
        double[] a4 = new double[a2 * a3];
        int a5 = 0;
        for (int a6 = 1; a6 <= a2; ++a6) {
            for (int a7 = 1; a7 <= a3; ++a7) {
                a4[a5++] = A2.get(a6, a7);
            }
        }
        return a4;
    }

    public static Matrix elementDivide(Matrix A1, Matrix A2) {
        AbstractBivariateRealFunction a2 = new AbstractBivariateRealFunction(){

            @Override
            public double evaluate(double a1, double a2) {
                double a3 = a1 / a2;
                return a3;
            }
            {
                2 a2;
            }
        };
        Matrix a3 = MatrixUtils.elementOperation(A1, A2, a2);
        return a3;
    }

    public static double[] rowSums(MatrixTable A2) {
        double[] a2 = new double[A2.nRows()];
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            a2[a3 - 1] = 0.0;
            for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                int n = a3 - 1;
                a2[n] = a2[n] + A2.get(a3, a4);
            }
        }
        return a2;
    }

    public static Vector[] toColumns(Matrix A2) {
        Vector[] a2 = new Vector[A2.nCols()];
        for (int a3 = 0; a3 < a2.length; ++a3) {
            a2[a3] = A2.getColumn(a3 + 1);
        }
        return a2;
    }

    private MatrixUtils() {
        MatrixUtils a2;
    }

    public static Vector colSumVector(MatrixTable A2) {
        return new DenseVector(MatrixUtils.colSums(A2));
    }

    public static double[] rowMeans(MatrixTable A2) {
        return DoubleArrayMath.scale(MatrixUtils.rowSums(A2), 1.0 / (double)A2.nCols());
    }

    public static double[][] to2DArray(MatrixTable A2) {
        int a2 = A2.nRows();
        int a3 = A2.nCols();
        double[][] a4 = new double[a2][a3];
        for (int a5 = 1; a5 <= a2; ++a5) {
            for (int a6 = 1; a6 <= a3; ++a6) {
                a4[a5 - 1][a6 - 1] = A2.get(a5, a6);
            }
        }
        return a4;
    }

    public static Vector rowMeanVector(MatrixTable A2) {
        return new DenseVector(MatrixUtils.rowMeans(A2));
    }

    public static String toString(MatrixTable A2) {
        int a2;
        int a3 = A2.nRows();
        int a4 = A2.nCols();
        StringBuilder a5 = new StringBuilder();
        a5.append(String.format("%dx%d\n", a3, a4));
        a5.append("\t");
        for (a2 = 1; a2 <= a4; ++a2) {
            a5.append(String.format("[,%d] ", a2));
        }
        a5.append("\n");
        for (a2 = 1; a2 <= a3; ++a2) {
            a5.append(String.format("[%d,] ", a2));
            for (int a6 = 1; a6 <= a4; ++a6) {
                a5.append(String.format("%f, ", A2.get(a2, a6)));
            }
            if (a2 == a3) continue;
            a5.append("\n");
        }
        return a5.toString();
    }

    public static Vector colMeanVector(MatrixTable A2) {
        return new DenseVector(MatrixUtils.colMeans(A2));
    }
}

