/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConjugateGradientNormalErrorSolver
implements IterativeLinearSystemSolver {
    private final int void;
    private final Tolerance class;
    private final int goto;
    public static final int DEFAULT_RESIDUAL_REFRESH_RATE = 50;
    private final PreconditionerFactory enum;

    public ConjugateGradientNormalErrorSolver(int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
            {
                1 a2;
            }
        }, 50, maxIteration, tolerance);
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private final int new;
            private final Vector super;
            private Vector final;
            private int break;
            private Vector else;
            private final Matrix catch;
            private double const;
            private final Matrix void;
            private Vector class;
            private boolean goto;
            private final Preconditioner enum;

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.break < this.new && !this.goto) {
                    this.step();
                    ++this.break;
                    this.goto |= ConjugateGradientNormalErrorSolver.this.class.isResidualSmall(this.final.norm());
                }
                monitor.addIterate(this.else);
                if (!this.goto) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, this.new + " iterations exceeded");
                }
                return this.else;
            }

            public void setInitials(Vector ... initials) {
                this.else = initials[0];
                this.final = this.super.minus(this.void.multiply(this.else));
                this.class = this.else.ZERO();
                this.goto = ConjugateGradientNormalErrorSolver.this.class.isResidualSmall(this.final.norm());
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.else);
                Vector a2 = this.enum.solve(this.final);
                double a3 = a2.innerProduct(this.final);
                if (Double.compare(a3, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<z, r> = 0");
                }
                double a4 = a3 / this.const;
                this.class = this.catch.multiply(a2).add(this.class.scaled(a4));
                Vector a5 = this.void.multiply(this.class);
                double a6 = this.class.innerProduct(this.class);
                if (Double.compare(a6, 0.0) == 0) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<p, p> = 0");
                }
                double a7 = a3 / a6;
                this.else = this.else.add(this.class.scaled(a7));
                this.final = (this.break + 1) % ConjugateGradientNormalErrorSolver.this.goto != 0 ? this.final.minus(a5.scaled(a7)) : this.super.minus(this.void.multiply(this.else));
                this.const = a3;
                return monitor;
            }
            {
                2 a3;
                a3.void = a3.problem.A();
                a3.catch = a3.void.t();
                a3.super = a3.problem.b();
                a3.new = Math.min(a3.ConjugateGradientNormalErrorSolver.this.void, a3.void.nCols());
                a3.enum = a3.ConjugateGradientNormalErrorSolver.this.enum.newInstance(a3.void);
                a3.const = 1.0;
                a3.break = 0;
            }
        };
    }

    public ConjugateGradientNormalErrorSolver(PreconditionerFactory leftPreconditionerFactory, int residualRefreshRate, int maxIteration, Tolerance tolerance) {
        this.enum = leftPreconditionerFactory;
        this.goto = residualRefreshRate;
        this.void = maxIteration;
        this.class = tolerance;
    }
}

