/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.misc.Constants;
import dev.nm.number.ScientificNotation;
import dev.nm.number.big.BigIntegerUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class HilbertMatrix
extends SymmetricMatrix {
    public HilbertMatrix(int n) {
        super(n);
        for (int a2 = 1; a2 <= n; ++a2) {
            for (int a3 = a2; a3 <= n; ++a3) {
                this.set(a2, a3, 1.0 / (double)(a2 + a3 - 1));
            }
        }
    }

    public BigInteger invdet() {
        int a2 = this.nRows();
        BigInteger a3 = BigIntegerUtils.factorial(a2);
        for (int a4 = 1; a4 <= 2 * a2 - 1; ++a4) {
            BigInteger a5 = BigIntegerUtils.combination(a4, a4 / 2);
            a3 = a3.multiply(a5);
        }
        return a3;
    }

    public double det() {
        ScientificNotation a2 = new ScientificNotation(this.invdet());
        BigDecimal a3 = BigDecimal.ONE.divide(a2.bigDecimalValue(), Math.abs(a2.exponent()) + Constants.MACH_SCALE, RoundingMode.HALF_EVEN);
        return a3.doubleValue();
    }
}

