/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GivensMatrix
implements Matrix {
    private final int super;
    private final double final;
    private static final ParallelExecutor break;
    private final double else;
    private final int catch;
    private final int const;
    private static int void;
    private static int class;
    private static final MatrixMathOperation goto;
    private static int enum;

    static {
        goto = new AutoParallelMatrixMathOperation();
        break = new ParallelExecutor(GivensMatrix.class.getSimpleName());
        void = 1000;
        enum = 1000;
        GivensMatrix.class = void * enum;
    }

    @Override
    public int nRows() {
        return this.super;
    }

    public String toString() {
        Object a2 = new DenseMatrix(this.super, this.super).ONE();
        a2.set(this.const, this.const, this.final);
        a2.set(this.catch, this.catch, this.final);
        a2.set(this.const, this.catch, this.else);
        a2.set(this.catch, this.const, -this.else);
        return a2.toString();
    }

    @Override
    public Matrix add(Matrix that) {
        return goto.add(this, that);
    }

    public double s() {
        return this.else;
    }

    @Override
    public GivensMatrix ONE() {
        return new GivensMatrix(this.super, 1, 2, 1.0, 0.0);
    }

    public static GivensMatrix CtorFromRho(int dim, int i2, int j2, double rho) {
        double a2;
        double a3;
        ArgumentAssertion.assertPositive(i2, "i");
        ArgumentAssertion.assertPositive(j2, "j");
        ArgumentAssertion.assertTrue(i2 <= dim && j2 <= dim && i2 != j2, "invalid specification", new Object[0]);
        if (DoubleUtils.equal(rho, 1.0, 0.0)) {
            a3 = 1.0;
            a2 = 0.0;
        } else if (DoubleUtils.compare(Math.abs(rho), 1.0, 0.0) < 0) {
            a3 = 2.0 * rho;
            a2 = Math.sqrt(1.0 - a3 * a3);
        } else {
            a2 = 2.0 / rho;
            a3 = Math.sqrt(1.0 - a2 * a2);
        }
        return new GivensMatrix(dim, i2, j2, a2, a3);
    }

    @Override
    public Vector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DenseVector a2 = new DenseVector(this.super, 0.0);
        a2.set(i2, this.get(i2, i2));
        a2.set(this.const, this.get(i2, this.const));
        a2.set(this.catch, this.get(i2, this.catch));
        return a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        return goto.minus(this, that);
    }

    public static GivensMatrix Ctor2x2(double c2, double s) {
        return new GivensMatrix(2, 1, 2, c2, s);
    }

    private static int do(int a2, int a3) {
        return 4;
    }

    public int j() {
        return this.catch;
    }

    @Override
    public Matrix scaled(double c2) {
        return goto.scaled(this, c2);
    }

    public GivensMatrix(GivensMatrix that) {
        this(that.super, that.const, that.catch, that.final, that.else);
    }

    public Matrix rightMultiplyInPlace(Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, this);
        int a2 = A2.nRows();
        for (int a3 = 1; a3 <= a2; ++a3) {
            double a4 = A2.get(a3, this.const);
            double a5 = A2.get(a3, this.catch);
            if (a4 == 0.0 && a5 == 0.0) continue;
            A2.set(a3, this.const, this.final * a4 - this.else * a5);
            A2.set(a3, this.catch, this.else * a4 + this.final * a5);
        }
        return A2;
    }

    private static Matrix short(GivensMatrix[] a2) {
        Matrix a3 = MatrixFactory.identity(a2[0].super, a2[0].super);
        for (int a4 = a2.length - 1; a4 >= 0; --a4) {
            if (a2[a4] == null) continue;
            a3 = a2[a4].multiplyInPlace(a3);
        }
        return a3;
    }

    public static GivensMatrix CtorToRotateColumns(int dim, int j1, int j2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (a5 == 0.0) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a2 / a5;
            double a7 = b2 / a5;
            double a8 = a5 * Math.hypot(a6, a7);
            a4 = a2 / a8;
            a3 = b2 / a8;
        }
        return new GivensMatrix(dim, j1, j2, a4, -a3);
    }

    @Override
    public Matrix multiply(Matrix A2) {
        DenseMatrix a2 = new DenseMatrix(A2);
        this.multiplyInPlace(a2);
        return a2;
    }

    @Deprecated
    public Vector rotate(Vector x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double rho() {
        double a2 = DoubleUtils.isZero(this.final, 0.0) ? 1.0 : (DoubleUtils.compare(Math.abs(this.else), Math.abs(this.final), 0.0) < 0 ? Math.signum(this.final) * this.else / 2.0 : 2.0 * Math.signum(this.else) / this.final);
        return a2;
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    public Matrix multiplyInPlace(Matrix A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, A2);
        int a2 = A2.nCols();
        for (int a3 = 1; a3 <= a2; ++a3) {
            double a4 = A2.get(this.const, a3);
            double a5 = A2.get(this.catch, a3);
            A2.set(this.const, a3, this.final * a4 + this.else * a5);
            A2.set(this.catch, a3, -this.else * a4 + this.final * a5);
        }
        return A2;
    }

    public Vector multiplyInPlace(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        double a2 = v.get(this.const);
        double a3 = v.get(this.catch);
        v.set(this.const, a2 * this.final + a3 * this.else);
        v.set(this.catch, a3 * this.final - a2 * this.else);
        return v;
    }

    @Override
    public GivensMatrix t() {
        return new GivensMatrix(this.super, this.const, this.catch, this.final, -this.else);
    }

    @Override
    @Deprecated
    public Matrix ZERO() {
        throw new UnsupportedOperationException("no zero matrix for GivensMatrix");
    }

    @Override
    public Vector multiply(Vector v) {
        Vector a2 = v.deepCopy();
        this.multiplyInPlace(a2);
        return a2;
    }

    public double c() {
        return this.final;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 29 * a2 + this.super;
        a2 = 29 * a2 + this.const;
        a2 = 29 * a2 + this.catch;
        a2 = 29 * a2 + (int)(Double.doubleToLongBits(this.final) ^ Double.doubleToLongBits(this.final) >>> 32);
        a2 = 29 * a2 + (int)(Double.doubleToLongBits(this.else) ^ Double.doubleToLongBits(this.else) >>> 32);
        return a2;
    }

    public static GivensMatrix CtorToRotateRows(int dim, int i1, int i2, double a2, double b2) {
        double a3;
        double a4;
        double a5 = Math.abs(a2) + Math.abs(b2);
        if (DoubleUtils.isZero(a5, 0.0)) {
            a4 = 1.0;
            a3 = 0.0;
        } else {
            double a6 = a5 * Math.sqrt(a2 / a5 * a2 / a5 + b2 / a5 * b2 / a5);
            a4 = a2 / a6;
            a3 = b2 / a6;
        }
        return new GivensMatrix(dim, i1, i2, a4, a3);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!GivensMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        GivensMatrix a2 = (GivensMatrix)obj;
        if (this.super != a2.super) {
            return false;
        }
        if (this.const != a2.const) {
            return false;
        }
        if (this.catch != a2.catch) {
            return false;
        }
        if (Double.doubleToLongBits(this.final) != Double.doubleToLongBits(a2.final)) {
            return false;
        }
        return Double.doubleToLongBits(this.else) == Double.doubleToLongBits(a2.else);
    }

    public Matrix rightMultiply(Matrix A2) {
        DenseMatrix a2 = new DenseMatrix(A2);
        this.rightMultiplyInPlace(a2);
        return a2;
    }

    public GivensMatrix(int dim, int i2, int j2, double c2, double s) {
        ArgumentAssertion.assertPositive(i2, "i");
        ArgumentAssertion.assertPositive(j2, "j");
        ArgumentAssertion.assertTrue(i2 <= dim && j2 <= dim && i2 != j2, "invalid specification", new Object[0]);
        this.super = dim;
        this.const = i2;
        this.catch = j2;
        this.final = c2;
        this.else = s;
    }

    public static GivensMatrix CtorToZeroOutEntry(Matrix A2, int i2, int j2) {
        double a2 = A2.get(i2 == 1 ? A2.nRows() : i2 - 1, j2);
        double a3 = A2.get(i2, j2);
        return GivensMatrix.CtorToRotateRows(A2.nRows(), i2 == 1 ? A2.nRows() : i2 - 1, i2, a2, a3);
    }

    @Override
    @Deprecated
    public void set(int row, int col, double value) {
        throw new MatrixAccessException("GivensMatrix is immutable");
    }

    public static GivensMatrix CtorToZeroOutEntryByTranspose(Matrix A2, int i2, int j2) {
        double a2 = A2.get(i2 == 1 ? A2.nRows() : i2 - 1, j2);
        double a3 = A2.get(i2, j2);
        return GivensMatrix.CtorToRotateColumns(A2.nRows(), i2 == 1 ? A2.nRows() : i2 - 1, i2, a2, a3);
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        DenseVector a2 = new DenseVector(this.super, 0.0);
        a2.set(j2, this.get(j2, j2));
        a2.set(this.const, this.get(this.const, j2));
        a2.set(this.catch, this.get(this.catch, j2));
        return a2;
    }

    private static Matrix do(final GivensMatrix[] a2) {
        int a3 = GivensMatrix.do(a2.length, a2[0].nRows());
        final int a4 = (int)Math.ceil((double)a2.length / (double)a3);
        ArrayList<1> a5 = new ArrayList<1>(a3);
        int a6 = 0;
        while (a6 < a3) {
            final int a7 = a6++;
            a5.add(new Callable<Matrix>(){
                {
                    1 a22;
                }

                @Override
                public Matrix call() throws Exception {
                    int a22 = a7 * a4;
                    int a3 = Math.min(a22 + a4, a2.length);
                    GivensMatrix[] a42 = Arrays.copyOfRange(a2, a22, a3);
                    return GivensMatrix.short(a42);
                }
            });
        }
        try {
            List a8 = break.executeAll(a5);
            Matrix a9 = (Matrix)a8.get(0);
            for (int a10 = 1; a10 < a8.size(); ++a10) {
                a9 = a9.multiply((Matrix)a8.get(a10));
            }
            return a9;
        }
        catch (MultipleExecutionException a11) {
            return GivensMatrix.short(a2);
        }
    }

    @Override
    public double get(int i2, int j2) {
        if (i2 == this.const && j2 == this.const) {
            return this.final;
        }
        if (i2 == this.catch && j2 == this.catch) {
            return this.final;
        }
        if (i2 == this.const && j2 == this.catch) {
            return this.else;
        }
        if (i2 == this.catch && j2 == this.const) {
            return -this.else;
        }
        if (i2 == j2) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public int nCols() {
        return this.super;
    }

    public int i() {
        return this.const;
    }

    @Override
    public GivensMatrix deepCopy() {
        return new GivensMatrix(this);
    }

    public static Matrix product(GivensMatrix[] Gs) {
        if (Gs.length == 0) {
            return null;
        }
        if (Gs.length * Gs[0].nRows() < GivensMatrix.class) {
            return GivensMatrix.short(Gs);
        }
        return GivensMatrix.do(Gs);
    }

    public static Matrix product(List<GivensMatrix> Gs) {
        return GivensMatrix.product(Gs.toArray(new GivensMatrix[Gs.size()]));
    }
}

