/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.DefaultDeflationCriterion;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.Deflation;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.DeflationCriterion;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TridiagonalDeflationSearch {
    private final DeflationCriterion void;
    private static final DefaultDeflationCriterion.MatrixNorm class = new DefaultDeflationCriterion.MatrixNorm(){
        {
            1 a2;
        }

        @Override
        public double compute(Matrix A2) {
            double a2 = 0.0;
            int a3 = A2.nRows();
            for (int a4 = 1; a4 <= a3; ++a4) {
                double a5 = A2.get(a4, a4);
                a2 += a5 * a5;
            }
            double a6 = 0.0;
            for (int a7 = 1; a7 <= a3 - 1; ++a7) {
                double a8 = A2.get(a7, a7 + 1);
                a6 += a8 * a8;
            }
            double a9 = Math.sqrt(a2 + (a6 *= 2.0));
            return a9;
        }
    };
    private final boolean goto;
    private final double enum;

    public TridiagonalDeflationSearch(DeflationCriterion deflationCriterion, boolean setNegligibleEntriesToZeros, double epsilon) {
        this.void = deflationCriterion;
        this.goto = setNegligibleEntriesToZeros;
        this.enum = epsilon;
    }

    public Deflation backSearch(Matrix D2, int startPosition) {
        int a2;
        int a3 = startPosition;
        if (this.goto) {
            this.do(D2, a3, this.enum);
        }
        int a4 = 0;
        for (a2 = a3 - 1; a4 < a3 && a2 > 0 && this.short(D2, a2 + 1, a2); ++a4, --a2) {
        }
        while (a2 > 0 && !this.short(D2, a2 + 1, a2)) {
            --a2;
        }
        if (a4 >= a3 - 1) {
            return null;
        }
        return new Deflation(a2 + 1, a3 - a4);
    }

    private boolean short(Matrix a2, int a3, int a4) {
        TridiagonalDeflationSearch a5;
        if (a5.goto) {
            return a2.get(a3, a4) == 0.0;
        }
        return a5.do(a2, a3, a4);
    }

    public TridiagonalDeflationSearch(boolean setNegligibleEntriesToZeros, double epsilon) {
        this(new DefaultDeflationCriterion(TridiagonalDeflationSearch.class), setNegligibleEntriesToZeros, epsilon);
    }

    public Deflation backSearch(Matrix D2) {
        return this.backSearch(D2, D2.nRows());
    }

    private boolean do(Matrix a2, int a3, int a4) {
        TridiagonalDeflationSearch a5;
        return a5.void.isNegligible(a2, a3, a4, a5.enum);
    }

    private void do(Matrix a2, int a3, double a4) {
        for (int a5 = 1; a5 <= a3 - 1; ++a5) {
            TridiagonalDeflationSearch a6;
            if (!a6.do(a2, a5 + 1, a5)) continue;
            a2.set(a5 + 1, a5, 0.0);
            a2.set(a5, a5 + 1, 0.0);
        }
    }
}

