/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.BlockRootRepresentation;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.BlockVector;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.EigenInfo;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.EigenvalueRefinementForInitialBlock;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.SymmetricEigenFor2x2Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.TestForPreservingRelativeAccuracy;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.UnreducedBlock;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MR3
implements Spectrum {
    private Vector long;
    private final boolean int;
    private static final double new;
    private static final double super;
    public static final double DEFAULT_MIN_RELATIVE_GAP = 0.001;
    private static final double final;
    private static final double break;
    private final double else;
    private final int catch;
    private static final double const;
    private final List<Vector> void;
    private Vector class;
    private final List<Double> goto;
    private static final double enum;

    private void do(UnreducedBlock[] a2) {
        for (UnreducedBlock a3 : a2) {
            for (EigenInfo a4 : a3.getEigenInfoList()) {
                MR3 a5;
                a5.goto.add(a4.getEigenvalue());
            }
        }
    }

    public MR3(Vector D2, Vector E2) {
        this(D2, E2, true, 0.001);
    }

    private void else() {
        MR3 a2;
        if (!a2.int) {
            Collections.sort(a2.goto, Collections.reverseOrder());
        } else {
            int a3;
            ArrayList<EigenPair> a4 = new ArrayList<EigenPair>(a2.catch);
            for (a3 = 0; a3 < a2.catch; ++a3) {
                a4.add(new EigenPair(a2.goto.get(a3), a2.void.get(a3)));
            }
            Collections.sort(a4, new Comparator<EigenPair>(){

                @Override
                public int compare(EigenPair pair1, EigenPair pair2) {
                    return -Double.compare(pair1.enum, pair2.enum);
                }
                {
                    1 a3;
                }
            });
            for (a3 = 0; a3 < a2.catch; ++a3) {
                EigenPair a5 = (EigenPair)a4.get(a3);
                a2.goto.set(a3, a5.enum);
                a2.void.set(a3, a5.goto);
            }
        }
    }

    private double do(Vector a2) {
        double a3 = a2.norm(Double.POSITIVE_INFINITY);
        double a4 = Math.max(1.0, a3 * a3) * new;
        return a4;
    }

    public List<Double> getEigenvalues() {
        return new ArrayList<Double>(this.goto);
    }

    private void break() {
        MR3 a2;
        switch (a2.catch) {
            case 0: {
                throw new IllegalArgumentException("dimension of the input matrix is zero");
            }
            case 1: {
                a2.short();
                break;
            }
            case 2: {
                a2.case();
            }
        }
    }

    static {
        const = Constants.MACH_EPS;
        new = 5.562684646268003E-309 * (1.0 + const);
        break = new / const;
        enum = 1.0 / break;
        super = Math.sqrt(break);
        final = Math.min(Math.sqrt(enum), 1.0 / Math.sqrt(Math.sqrt(new)));
    }

    public MR3(Vector D2, Vector E2, boolean wantEigenvector) {
        this(D2, E2, wantEigenvector, 0.001);
    }

    private double do(double a2) {
        double a3 = 1.0;
        if (a2 > 0.0 && a2 < super) {
            a3 = super / a2;
        } else if (a2 > final) {
            a3 = final / a2;
        }
        if (a3 != 1.0) {
            MR3 a4;
            a4.long = a4.long.scaled(a3);
            a4.class = a4.class.scaled(a3);
        }
        return a3;
    }

    public MR3(Vector D2, Vector E2, boolean wantEigenvector, double minRelativeGap) {
        ArgumentAssertion.assertTrue(D2.size() == 1 || D2.size() == E2.size() + 1, "D's size must be greater than E's size by 1", new Object[0]);
        this.long = D2.deepCopy();
        this.class = E2 != null ? E2.deepCopy() : null;
        this.int = wantEigenvector;
        this.else = minRelativeGap;
        this.catch = D2.size();
        this.goto = new ArrayList<Double>(this.catch);
        this.void = new ArrayList<Vector>(this.catch);
        if (this.catch <= 2) {
            this.break();
        } else {
            this.goto();
        }
        this.else();
    }

    public Matrix getEigenvectorMatrix() {
        this.do();
        return MatrixFactory.cbind(this.void);
    }

    private double do(Vector a2, Vector a3) {
        return Math.max(a2.norm(Double.POSITIVE_INFINITY), a3.norm(Double.POSITIVE_INFINITY));
    }

    public List<Vector> getEigenvectors() {
        this.do();
        return Collections.unmodifiableList(this.void);
    }

    private void goto() {
        MR3 a2;
        double a3 = a2.do(a2.long, a2.class);
        double a4 = a2.do(a3);
        double a5 = a4 * a3;
        TestForPreservingRelativeAccuracy a6 = new TestForPreservingRelativeAccuracy();
        boolean a7 = a6.canPreserveRelativeAccuracy(a2.long, a2.class);
        double a8 = a7 ? const : -const;
        double a9 = a2.do(a2.class);
        BlockRootRepresentation a10 = new BlockRootRepresentation(a2.long, a2.class, a8, a9);
        double a11 = a10.getEigenLowerBound();
        UnreducedBlock[] a12 = a10.getUnreducedBlocks();
        if (a2.int) {
            BlockVector a13 = new BlockVector(a2.catch, a11, a9, a2.else);
            a2.void.addAll(a13.computeEigenvectors(a12));
        }
        if (a7) {
            a2.do(a12, a9, a5);
        }
        a2.do(a12);
        a2.do(a4);
    }

    private void case() {
        MR3 a2;
        SymmetricEigenFor2x2Matrix a3 = new SymmetricEigenFor2x2Matrix(a2.long.get(1), a2.class.get(1), a2.long.get(2));
        a2.goto.addAll(a3.getEigenvalues());
        if (a2.int) {
            a2.void.addAll(a3.getEigenvectors());
        }
    }

    private void short() {
        MR3 a2;
        a2.goto.add(a2.long.get(1));
        if (a2.int) {
            a2.void.add(new DenseVector(1.0));
        }
    }

    private void do(UnreducedBlock[] a2, double a3, double a4) {
        for (UnreducedBlock a5 : a2) {
            if (a5.size < 1) continue;
            double a6 = 4.0 * const;
            EigenvalueRefinementForInitialBlock a7 = new EigenvalueRefinementForInitialBlock(a5, a6, a3, a4);
            a7.compute();
        }
    }

    private void do() {
        MR3 a2;
        if (!a2.int) {
            throw new UnsupportedOperationException("eigenvectors were not computed");
        }
    }

    private void do(double a2) {
        if (a2 != 1.0) {
            MR3 a3;
            for (int a4 = 0; a4 < a3.goto.size(); ++a4) {
                double a5 = a3.goto.get(a4);
                a3.goto.set(a4, a5 / a2);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class EigenPair {
        private final Vector goto;
        private final double enum;

        private EigenPair(double a2, Vector a3) {
            EigenPair a4;
            a4.enum = a2;
            a4.goto = a3;
        }
    }
}

