/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints.ybar;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPNoTradingList2
extends SOCPPortfolioConstraint {
    private final int void;
    private final int class;
    private final double goto;
    private final Matrix enum;

    public SOCPNoTradingList2(Vector w_0, Matrix D_BL0, double epsilon) {
        this.class = w_0.size();
        this.void = w_0.size();
        this.enum = D_BL0;
        this.goto = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.void));
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 1; a4 <= this.void; ++a4) {
            a3.add(new SparseMatrix.Entry(new MatrixCoordinate(a4, a4), this.enum.get(a4, a4)));
        }
        CSRSparseMatrix a5 = new CSRSparseMatrix(this.void, this.void, a3);
        ArrayList<SparseVector.Entry> a6 = new ArrayList<SparseVector.Entry>();
        for (int a7 = 1; a7 <= this.void; ++a7) {
            a6.add(new SparseVector.Entry(a7, -this.enum.get(a7, a7) * w_0.get(a7)));
        }
        SparseVector a8 = new SparseVector(this.void, a6);
        SparseVector a9 = new SparseVector(this.void);
        double a10 = 0.0;
        a2.add(new SOCPGeneralConstraint(a5.t(), a8, a9, a10));
        SOCPGeneralConstraints a11 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("ybar", this.void));
        ArrayList<SparseVector.Entry> a12 = new ArrayList<SparseVector.Entry>();
        for (int a13 = 1; a13 <= this.void; ++a13) {
            a12.add(new SparseVector.Entry(a13, -this.enum.get(a13, a13) * Math.abs(w_0.get(a13))));
        }
        SparseVector a14 = new SparseVector(this.void, a12);
        a11.add(new SOCPGeneralConstraint(a5.t(), a14, a9, a10));
        SOCPGeneralConstraints a15 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("xbar", this.void));
        SparseVector a16 = new SparseVector(this.void);
        a15.add(new SOCPGeneralConstraint(a5.t(), a16, a9, a10));
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = 0.0;
        int a3 = 0;
        for (int a4 = 1; a4 <= this.void; ++a4) {
            if (!(this.enum.get(a4, a4) > 0.0)) continue;
            a2 += Math.abs(x.get(a4));
            ++a3;
        }
        double a5 = a3 > 0 ? a2 / (double)a3 : 0.0;
        return a5;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    public SOCPNoTradingList2(Vector w_0, Matrix D_BL0) {
        this(w_0, D_BL0, 0.01);
    }

    @Override
    public int dimensionOfDomain() {
        return this.class;
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        double a2 = this.evaluate(y);
        int a3 = DoubleUtils.compare(a2, 0.0, this.goto);
        if (a3 != 0) {
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("non-zero position for a black listed asset: %f", a2));
        }
        return true;
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }
}

