/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.regression.linear.heteroskedasticity;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.stat.distribution.univariate.ChiSquareDistribution;
import dev.nm.stat.regression.linear.LMProblem;
import dev.nm.stat.regression.linear.ols.OLSRegression;
import dev.nm.stat.regression.linear.residualanalysis.LMResiduals;
import dev.nm.stat.test.HypothesisTest;

public abstract class Heteroskedasticity
extends HypothesisTest {
    protected final int N;
    protected final LMResiduals residuals;

    @Override
    public double pValue() {
        return Heteroskedasticity.oneSidedPvalue(this.getX2(), this.statistics());
    }

    @Override
    public double statistics() {
        OLSRegression a2 = this.getAuxiliaryRegression();
        return (double)this.N * a2.residuals().R2();
    }

    protected ChiSquareDistribution getX2() {
        return new ChiSquareDistribution(this.residuals.getProblem().nExogenousFactors());
    }

    protected abstract OLSRegression getAuxiliaryRegression();

    @Override
    public String getAlternativeHypothesis() {
        return "there is conditional heteroscedasticity";
    }

    public Heteroskedasticity(LMResiduals residuals) {
        super(new double[0][]);
        this.residuals = residuals;
        this.N = residuals.getProblem().nObs();
    }

    @Override
    public String getNullHypothesis() {
        return "there is homoskedasticity";
    }

    protected OLSRegression getAuxiliaryOLSRegression(Vector y, LMResiduals residuals) {
        LMProblem a2 = new LMProblem(y, (Matrix)residuals.getProblem().X(), true);
        OLSRegression a3 = new OLSRegression(a2);
        return a3;
    }
}

