/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.distribution.normality;

import dev.nm.stat.descriptive.moment.Kurtosis;
import dev.nm.stat.descriptive.moment.Skewness;
import dev.nm.stat.distribution.univariate.ChiSquareDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.test.HypothesisTest;
import dev.nm.stat.test.distribution.normality.JarqueBeraDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JarqueBera
extends HypothesisTest {
    private final boolean class;
    public final int nSim = 50000;
    private final double goto;
    private final double enum;

    @Override
    public double statistics() {
        int a2 = this.nObs();
        double a3 = (this.enum * this.enum + this.goto * this.goto / 4.0) * (double)a2 / 6.0;
        return a3;
    }

    @Override
    public String getNullHypothesis() {
        return "both the skewness and the excess kurtosis are 0";
    }

    @Override
    public double pValue() {
        int a2 = this.nObs();
        ProbabilityDistribution a3 = new ChiSquareDistribution(2.0);
        if (this.class && a2 <= 2000) {
            a3 = new JarqueBeraDistribution(a2, 50000);
        }
        double a4 = this.statistics();
        double a5 = JarqueBera.oneSidedPvalue(a3, a4);
        return a5;
    }

    public JarqueBera(double[] sample) {
        this(sample, false);
    }

    public JarqueBera(double[] sample, boolean isExact) {
        super(new double[][]{sample});
        this.class = isExact;
        Skewness a2 = new Skewness(sample);
        this.enum = a2.sample();
        Kurtosis a3 = new Kurtosis(sample);
        this.goto = a3.sample();
    }

    @Override
    public String getAlternativeHypothesis() {
        return "either the skewness or the excess kurtosis is non-zero";
    }
}

