/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.markovchain;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.random.rng.multivariate.MultinomialRVG;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleMC
implements RandomNumberGenerator {
    private int void = -1;
    private final ImmutableMatrix class;
    private MultinomialRVG[] goto;
    private final ImmutableVector enum;

    static {
        Package.validate("NMDEV_STAT");
    }

    @Override
    public double nextDouble() {
        return this.nextState();
    }

    @Override
    public void seed(long ... seeds) {
        for (int a2 = 0; a2 < this.goto.length; ++a2) {
            this.goto[a2].seed(seeds);
        }
    }

    public int nextState() {
        int a2;
        MultinomialRVG a3 = this.goto[0];
        if (this.void != -1) {
            a3 = this.goto[this.void];
        }
        this.void = a2 = SimpleMC.bin(a3);
        return a2;
    }

    public ImmutableMatrix A() {
        return this.class;
    }

    public static int bin(MultinomialRVG rvg) {
        double[] a2 = rvg.nextVector();
        int a3 = 1;
        while (a2[a3 - 1] == 0.0) {
            ++a3;
        }
        return a3;
    }

    public SimpleMC(Vector PI, Matrix A2) {
        int a2 = A2.nRows();
        ArgumentAssertion.assertTrue(PI.size() == a2, "the length of PI should be the same as the number of states", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == a2, "A should be a square matrix", new Object[0]);
        this.enum = new ImmutableVector(PI);
        this.class = new ImmutableMatrix(A2);
        this.goto = new MultinomialRVG[1 + A2.nRows()];
        this.goto[0] = new MultinomialRVG(1, PI.toArray());
        for (int a3 = 1; a3 < this.goto.length; ++a3) {
            this.goto[a3] = new MultinomialRVG(1, A2.getRow(a3).toArray());
        }
    }

    public int nStates() {
        return this.class.nRows();
    }

    public ImmutableVector PI() {
        return this.enum;
    }

    public static Vector getStationaryProbabilities(Matrix A2) {
        int a2 = A2.nRows();
        Matrix a3 = A2.t().minus(A2.ONE());
        ((DenseMatrix)a3).setRow(a2, new DenseVector(a2, 1.0));
        DenseVector a4 = new DenseVector(a2, 0.0);
        a4.set(a2, 1.0);
        Vector a5 = new Inverse(a3).multiply(a4);
        return a5;
    }
}

