/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.hmm.HMMRNG;
import dev.nm.stat.hmm.HmmInnovation;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;

public abstract class HiddenMarkovModel
extends HMMRNG {
    public abstract double density(int var1, double var2);

    public HiddenMarkovModel(Vector PI, Matrix A2, RandomNumberGenerator[] B2) {
        super(PI, A2, B2);
    }

    public HiddenMarkovModel(HMMRNG hmm) {
        super(hmm);
    }

    public double logProbability(int[] states, double[] obsverations) {
        int a2;
        int a3 = states.length;
        int a4 = states[a2];
        double a5 = Math.log(this.PI().get(a4));
        a5 += Math.log(this.density(a4, obsverations[0]));
        for (a2 = 0; a2 < a3 - 1; ++a2) {
            a4 = states[a2];
            int a6 = states[a2 + 1];
            double a7 = this.A().get(a4, a6);
            a5 += Math.log(a7) + Math.log(this.density(a6, obsverations[a2 + 1]));
        }
        return a5;
    }

    public double logProbability(HmmInnovation[] innovations) {
        int a2 = innovations.length;
        int[] a3 = new int[a2];
        double[] a4 = new double[a2];
        for (int a5 = 0; a5 < a2; ++a5) {
            a3[a5] = innovations[a5].state();
            a4[a5] = innovations[a5].observation();
        }
        return this.logProbability(a3, a4);
    }

    public double logProbability(int[] states, int[] obsverations) {
        return this.logProbability(states, DoubleUtils.intArray2doubleArray(obsverations));
    }
}

