/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.dlm.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.CholeskyWang2006;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.function.matrix.R1toConstantMatrix;
import dev.nm.analysis.function.matrix.R1toMatrix;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.license.Package;
import dev.nm.stat.dlm.univariate.StateEquation;
import dev.nm.stat.random.rng.multivariate.NormalRVG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateStateEquation {
    private final R1toMatrix const;
    private final R1toMatrix void;
    private final int class;
    private final NormalRVG goto;
    private final R1toMatrix enum;

    public ImmutableMatrix xt_var(int t, Matrix var_tlag_tlag) {
        Matrix a2 = this.G(t);
        Matrix a3 = this.W(t);
        Matrix a4 = new CongruentMatrix(a2.t(), var_tlag_tlag).add(a3);
        return new ImmutableMatrix(a4);
    }

    public Matrix W(int t) {
        return this.const.evaluate(t);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H2, R1toMatrix W) {
        this(G2, H2, W, null);
    }

    public MultivariateStateEquation(Matrix G2, Matrix H2, Matrix W, NormalRVG rmvnorm) {
        this(new R1toConstantMatrix(G2), H2 != null ? new R1toConstantMatrix(H2) : null, new R1toConstantMatrix(W), rmvnorm);
    }

    public Matrix G(int t) {
        return this.enum.evaluate(t);
    }

    public ImmutableVector xt(int t, Vector xt_1) {
        ArgumentAssertion.assertTrue(this.void == null, "H is not null and thus it requires the control variable", new Object[0]);
        return this.xt(t, xt_1, null);
    }

    public int dimension() {
        return this.class;
    }

    public Vector xt_mean(int t, Vector xt_1) {
        return this.xt_mean(t, xt_1, null);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix H2, R1toMatrix W, NormalRVG rmvnorm) {
        this.class = G2.evaluate(1.0).nRows();
        ArgumentAssertion.assertTrue(W.evaluate(1.0).nRows() == this.class && W.evaluate(1.0).nCols() == this.class, "the dimension of W is the dimension of each state x_t", new Object[0]);
        if (H2 != null) {
            ArgumentAssertion.assertTrue(H2.evaluate(1.0).nRows() == this.class, "the dimension of W is the dimension of each state x_t", new Object[0]);
        }
        this.enum = G2;
        this.void = H2;
        this.const = W;
        this.goto = rmvnorm == null ? new NormalRVG(this.class) : rmvnorm;
    }

    public MultivariateStateEquation(final StateEquation states) {
        this(new R1toMatrix(){

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.G((int)t)}});
            }
            {
                1 a2;
            }
        }, new R1toMatrix(){
            {
                2 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.H((int)t)}});
            }
        }, new R1toMatrix(){
            {
                3 a2;
            }

            @Override
            public Matrix evaluate(double t) {
                return new DenseMatrix(new double[][]{{states.W((int)t)}});
            }
        });
    }

    public ImmutableVector xt(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.xt_mean(t, xt_1, ut);
        Matrix a3 = this.const.evaluate(t);
        LowerTriangularMatrix a4 = new CholeskyWang2006(a3, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(a3))).L();
        Vector a5 = a4.multiply(new DenseVector(this.goto.nextVector()));
        a2 = a2.add(a5);
        return new ImmutableVector(a2);
    }

    public MultivariateStateEquation(R1toMatrix G2, R1toMatrix W) {
        this(G2, null, W);
    }

    public MultivariateStateEquation(Matrix G2, Matrix W) {
        this(G2, null, W, null);
    }

    public Matrix H(int t) {
        return this.void != null ? this.void.evaluate(t) : null;
    }

    public MultivariateStateEquation(MultivariateStateEquation that) {
        this(that.enum, that.void, that.const);
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public Vector xt_mean(int t, Vector xt_1, Vector ut) {
        Vector a2 = this.enum.evaluate(t).multiply(xt_1);
        if (this.void != null) {
            Vector a3 = this.void.evaluate(t).multiply(ut);
            a2 = a2.add(a3);
        }
        return a2;
    }
}

