/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.beta.BetaRegularizedInverse;
import dev.nm.analysis.function.special.beta.LogBeta;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BetaDistribution
implements ProbabilityDistribution {
    private final BetaRegularizedInverse catch;
    private final double const;
    private static final Digamma void;
    private final double class;
    private final BetaRegularized goto;
    private static final LogBeta enum;

    @Override
    public double entropy() {
        double a2 = enum.evaluate(this.class, this.const);
        a2 -= (this.class - 1.0) * void.evaluate(this.class);
        a2 -= (this.const - 1.0) * void.evaluate(this.const);
        return a2 += (this.class + this.const - 2.0) * void.evaluate(this.class + this.const);
    }

    @Override
    public double mean() {
        return this.class / (this.class + this.const);
    }

    @Override
    public double quantile(double u) {
        double a2 = this.catch.evaluate(u);
        return a2;
    }

    static {
        enum = new LogBeta();
        void = new Digamma();
    }

    public BetaDistribution(double alpha, double beta) {
        ArgumentAssertion.assertPositive(alpha, "alpha");
        ArgumentAssertion.assertPositive(beta, "beta");
        this.class = alpha;
        this.const = beta;
        this.goto = new BetaRegularized(alpha, beta);
        this.catch = new BetaRegularizedInverse(alpha, beta);
    }

    @Override
    public double kurtosis() {
        double a2 = 6.0;
        a2 *= this.class * this.class * this.class - this.class * this.class * (2.0 * this.const - 1.0) + this.const * this.const * (this.const + 1.0) - 2.0 * this.class * this.const * (this.const + 2.0);
        return a2 /= this.class * this.const * (this.class + this.const + 2.0) * (this.class + this.const + 3.0);
    }

    @Override
    public double variance() {
        double a2 = this.class + this.const;
        double a3 = this.class * this.const;
        return a3 /= a2 * a2 * (a2 + 1.0);
    }

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        return this.goto.evaluate(x);
    }

    @Override
    public double skew() {
        double a2 = this.class + this.const;
        double a3 = 2.0 * (this.const - this.class) * Math.sqrt(a2 + 1.0);
        return a3 /= (a2 + 2.0) * Math.sqrt(this.class * this.const);
    }

    @Override
    public double density(double x) {
        assert (x >= 0.0) : "x must be >= 0";
        assert (x <= 1.0) : "x must be <= 1";
        if (DoubleUtils.isZero(x, 0.0)) {
            if (this.class < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        double a2 = (this.class - 1.0) * Math.log(x) + (this.const - 1.0) * Math.log(1.0 - x) - enum.evaluate(this.class, this.const);
        a2 = Math.exp(a2);
        return a2;
    }

    @Override
    @Deprecated
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double ccdf(double x) {
        return 1.0 - this.cdf(x);
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("no closed form.");
    }
}

