/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.cointegration;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.CongruentMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.license.Package;
import dev.nm.stat.cointegration.AuxiliaryRegression1;
import dev.nm.stat.cointegration.AuxiliaryRegression2;
import dev.nm.stat.timeseries.datastructure.multivariate.realtime.inttime.MultivariateSimpleTimeSeries;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CointegrationMLE {
    private final ImmutableVector void;
    private final int class;
    private final ImmutableMatrix goto;
    private final DenseMatrix enum;

    public int rank() {
        return this.void.size();
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept) {
        this(ts, intercept, 2);
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept, int p) {
        this(ts, intercept, p, null);
    }

    static {
        Package.validate("NMDEV_STAT");
    }

    public Vector getEigenvalues() {
        return this.void;
    }

    public Vector beta(int r) {
        return new ImmutableVector(this.enum.getColumn(r));
    }

    public CointegrationMLE(MultivariateSimpleTimeSeries ts, boolean intercept, int p, Matrix D2) {
        ArgumentAssertion.assertNotLessThan(p, 1, "p");
        double a2 = PrecisionUtils.autoEpsilon(ts.toMatrix());
        int a3 = ts.dimension();
        int a4 = ts.size();
        int a5 = D2 == null ? 0 : D2.nCols();
        ArgumentAssertion.assertTrue(D2 == null || D2.nRows() == a4, "D and the multivariate time series must have the same number of rows (timed data)", new Object[0]);
        this.class = a4 - p;
        int a6 = a3 * (p - 1) + a5 + (intercept ? 1 : 0);
        ArgumentAssertion.assertTrue(a4 - p > a6 + p * (p + 1) / 2, "the multivariate time series must be long enough for estimation (enough timed data)", new Object[0]);
        AuxiliaryRegression1 a7 = new AuxiliaryRegression1(ts, p, D2, intercept);
        AuxiliaryRegression2 a8 = new AuxiliaryRegression2(ts, p, D2, intercept);
        ImmutableMatrix a9 = a7.errors();
        ImmutableMatrix a10 = a8.errors();
        Matrix a11 = a9.t().multiply(a9).scaled(1.0 / (double)this.class);
        Matrix a12 = a9.t().multiply(a10).scaled(1.0 / (double)this.class);
        Matrix a13 = a12.t();
        Matrix a14 = a10.t().multiply(a10).scaled(1.0 / (double)this.class);
        Chol a15 = new Chol(a14, a2);
        LowerTriangularMatrix a16 = a15.L();
        Inverse a17 = new Inverse(a16, a2);
        Matrix a18 = a17.multiply(a13).multiply(new Inverse(a11, a2)).multiply(a12).multiply(a17.t());
        Eigen a19 = new Eigen(a18);
        this.void = new ImmutableVector(new DenseVector(a19.getRealEigenvalues()));
        int a20 = this.void.size();
        this.enum = new DenseMatrix(a3, a20);
        for (int a21 = 0; a21 < a20; ++a21) {
            EigenProperty a22 = a19.getProperty(a21);
            Vector a23 = a17.t().multiply(a22.eigenVector());
            a23 = a23.scaled(1.0 / a23.get(1));
            this.enum.setColumn(a21 + 1, a23);
        }
        this.goto = new ImmutableMatrix(a12.multiply(this.enum).multiply(new Inverse((Matrix)new CongruentMatrix((Matrix)this.enum, a14), a2)));
    }

    public int n() {
        return this.class;
    }

    public Matrix beta() {
        return new ImmutableMatrix(this.enum);
    }

    public Matrix alpha() {
        return this.goto;
    }
}

