/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.problem;

import dev.nm.analysis.differentiation.multivariate.GradientFunction;
import dev.nm.analysis.differentiation.multivariate.HessianFunction;
import dev.nm.analysis.function.matrix.RntoMatrix;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.solver.problem.C2OptimProblem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class C2OptimProblemImpl
implements C2OptimProblem {
    private final RealVectorFunction class;
    private final RntoMatrix goto;
    private final RealScalarFunction enum;

    public C2OptimProblemImpl(RealScalarFunction f2, RealVectorFunction g2) {
        this(f2, g2, new HessianFunction(f2));
    }

    public C2OptimProblemImpl(RealScalarFunction f2, RealVectorFunction g2, RntoMatrix H2) {
        ArgumentAssertion.assertTrue(f2.dimensionOfDomain() == g2.dimensionOfDomain(), "objective function and gradient must have the same domain dimension", new Object[0]);
        ArgumentAssertion.assertTrue(f2.dimensionOfDomain() == H2.dimensionOfDomain(), "objective function and Hessian must have the same domain dimension", new Object[0]);
        this.enum = f2;
        this.class = g2;
        this.goto = H2;
    }

    public C2OptimProblemImpl(C2OptimProblemImpl that) {
        this(that.enum);
    }

    public C2OptimProblemImpl(RealScalarFunction f2) {
        this(f2, new GradientFunction(f2));
    }

    @Override
    public RealVectorFunction g() {
        return this.class;
    }

    @Override
    public RealScalarFunction f() {
        return this.enum;
    }

    @Override
    public RntoMatrix H() {
        return this.goto;
    }

    @Override
    public int dimension() {
        return this.enum.dimensionOfDomain();
    }
}

