/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.general.penaltymethod;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.solver.multivariate.constrained.constraint.Constraints;
import dev.nm.solver.multivariate.constrained.constraint.ConstraintsUtils;
import dev.nm.solver.multivariate.constrained.constraint.LessThanConstraints;
import dev.nm.solver.multivariate.constrained.general.penaltymethod.MultiplierPenalty;

public class FletcherPenalty
extends MultiplierPenalty {
    public FletcherPenalty(LessThanConstraints constraints) {
        this(constraints, 1.0);
    }

    public FletcherPenalty(LessThanConstraints constraints, double weight) {
        super((Constraints)constraints, weight);
    }

    public FletcherPenalty(LessThanConstraints constraints, double[] weights) {
        super((Constraints)constraints, weights);
    }

    @Override
    public Double evaluate(Vector x) {
        Vector a2 = ConstraintsUtils.evaluate(this.constraints, x);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= a2.size(); ++a4) {
            double a5 = a2.get(a4);
            a3 += this.weights[a4 - 1] * Math.max(a5, 0.0) * Math.max(a5, 0.0);
        }
        return a3 /= 2.0;
    }
}

