/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.pivoting;

import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.exception.LPUnbounded;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.SimplexTable;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.lp.simplex.pivoting.SimplexPivoting;

public class NaiveRule
implements SimplexPivoting {
    @Override
    public int ratioTest(SimplexTable table, int s) {
        int a2 = 0;
        double a3 = Double.MAX_VALUE;
        for (int a4 = 1; a4 < table.nRows(); ++a4) {
            double a5;
            double a6;
            if (table.getRowLabel((int)a4).type != SimplexTable.LabelType.BASIC && table.getRowLabel((int)a4).type != SimplexTable.LabelType.NON_BASIC && table.getRowLabel((int)a4).type != SimplexTable.LabelType.ARTIFICIAL || (a6 = table.get(a4, s)) >= 0.0) continue;
            double a7 = table.getBCol(a4);
            double a8 = -a7 / a6;
            if (!(a8 < a3 - (a5 = PrecisionUtils.autoEpsilon(a8))) && (DoubleUtils.compare(a8, a3, a5) != 0 || table.getRowLabel((int)a4).index >= table.getRowLabel((int)a2).index)) continue;
            a3 = a8;
            a2 = a4;
        }
        return a2;
    }

    @Override
    public int pricing(SimplexTable table) {
        int a2 = 0;
        for (int a3 = 1; a3 < table.nCols(); ++a3) {
            if (table.getColLabel((int)a3).type != SimplexTable.LabelType.NON_BASIC && table.getColLabel((int)a3).type != SimplexTable.LabelType.BASIC && table.getColLabel((int)a3).type != SimplexTable.LabelType.FREE || !(table.getCostRow(a3) < 0.0)) continue;
            a2 = a2 == 0 ? a3 : (table.getCostRow(a3) < table.getCostRow(a2) ? a3 : a2);
        }
        return a2;
    }

    @Override
    public SimplexPivoting.Pivot getPivot(SimplexTable table) throws LPUnbounded {
        int a2 = this.pricing(table);
        if (a2 == 0) {
            return null;
        }
        int a3 = this.ratioTest(table, a2);
        if (a3 == 0) {
            throw new LPUnbounded(a2);
        }
        return new SimplexPivoting.Pivot(a3, a2);
    }
}

