/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.LDLt;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.RealVectorSpace;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.QuadraticFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearEqualityConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPInfeasible;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.QPSolution;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.qp.problem.QPProblemOnlyEqualityConstraints;

public class QPSimpleMinimizer {
    static {
        Package.validate("NMDEV_SOLVER");
    }

    public static QPSolution solve(QuadraticFunction f2, final double epsilon) throws QPInfeasible {
        Object a2;
        ImmutableMatrix a3 = f2.Hessian();
        ImmutableVector a4 = f2.p();
        LDLt a5 = new LDLt(new SymmetricMatrix(a3));
        DiagonalMatrix a6 = a5.D();
        double[] a7 = VectorFactory.diagonal(a6).toArray();
        final double a8 = DoubleArrayMath.min(a7);
        ArgumentAssertion.assertFalse(DoubleUtils.isNegative(a8, epsilon), "the Hessian matrix is not positive (semi-)definite", new Object[0]);
        if (DoubleUtils.isZero(a8, epsilon) && !((RealVectorSpace)(a2 = new RealVectorSpace(a3, epsilon))).isSpanned(a4)) {
            throw new QPInfeasible();
        }
        a2 = a5.L();
        UpperTriangularMatrix a9 = a5.Lt();
        Vector a10 = new ForwardSubstitution().solve((LowerTriangularMatrix)a2, a4.scaled(-1.0));
        Object a11 = a10.ZERO();
        for (int a12 = 1; a12 <= a11.size(); ++a12) {
            if (DoubleUtils.isZero(a6.get(a12, a12), epsilon)) {
                if (DoubleUtils.isZero(a10.get(a12), epsilon)) continue;
                throw new QPInfeasible();
            }
            a11.set(a12, a10.get(a12) / a6.get(a12, a12));
        }
        final Vector a13 = new BackwardSubstitution().solve(a9, (Vector)a11);
        return new QPSolution(){

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a13);
            }
            {
                1 a2;
            }

            @Override
            public boolean isUnique() {
                return !DoubleUtils.isZero(a8, epsilon);
            }
        };
    }

    public static QPSolution solve(QuadraticFunction f2, LinearEqualityConstraints equal, double epsilon) throws QPInfeasible {
        QPProblemOnlyEqualityConstraints a2 = new QPProblemOnlyEqualityConstraints(f2, equal);
        final QPSolution a3 = QPSimpleMinimizer.solve((QuadraticFunction)a2, epsilon);
        final ImmutableVector a4 = a2.getSolutionToOriginalProblem(a3.minimizer());
        return new QPSolution(){

            @Override
            public boolean isUnique() {
                return a3.isUnique();
            }
            {
                2 a2;
            }

            @Override
            public ImmutableVector minimizer() {
                return new ImmutableVector(a4);
            }
        };
    }

    public static QPSolution solve(QuadraticFunction f2, LinearEqualityConstraints equal) throws QPInfeasible {
        return QPSimpleMinimizer.solve(f2, equal, PrecisionUtils.autoEpsilon(f2.Hessian()));
    }

    public static QPSolution solve(QuadraticFunction f2) throws QPInfeasible {
        return QPSimpleMinimizer.solve(f2, PrecisionUtils.autoEpsilon(f2.Hessian()));
    }
}

