/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.geometry.polyline;

import dev.nm.geometry.Point;
import dev.nm.geometry.polyline.PolygonalChain;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PolygonalChainByArray
implements PolygonalChain {
    private final int goto;
    private final List<Point> enum;

    public PolygonalChainByArray(List<? extends Point> vertices) {
        ArgumentAssertion.assertTrue(!vertices.isEmpty(), "list of points must not be empty", new Object[0]);
        this.goto = vertices.get(0).dimension();
        ArrayList<Point> a2 = new ArrayList<Point>(vertices.size());
        for (Point point : vertices) {
            ArgumentAssertion.assertTrue(point.dimension() == this.goto, "Vector %s has a different number of dimensions (%d expected)", point, this.goto);
            a2.add(point);
        }
        this.enum = Collections.unmodifiableList(a2);
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public List<Point> vertices() {
        return this.enum;
    }

    @Override
    public int dimension() {
        return this.goto;
    }
}

