/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.geometry;

import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.geometry.Point;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LineSegment {
    private final Point goto;
    private final Point enum;

    public double length() {
        return this.goto.distance(this.enum);
    }

    public double perpendicularDistance(Point p) {
        this.do(p);
        if (this.length() == 0.0) {
            return p.distance(this.goto);
        }
        Vector a2 = this.goto.getCoordinates().minus(p.getCoordinates());
        Vector a3 = this.enum.getCoordinates().minus(this.goto.getCoordinates());
        a3 = a3.scaled(1.0 / a3.norm());
        Vector a4 = a3.scaled(a2.innerProduct(a3));
        Vector a5 = a2.minus(a4);
        return a5.norm();
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    public Point getEndPoint1() {
        return this.goto;
    }

    public double distance(Point p) {
        this.do(p);
        double a2 = this.length();
        if (a2 == 0.0) {
            return p.distance(this.goto);
        }
        ImmutableVector a3 = this.goto.getCoordinates();
        ImmutableVector a4 = this.enum.getCoordinates();
        ImmutableVector a5 = p.getCoordinates();
        Vector a6 = a4.minus(a3);
        double a7 = a5.minus(a3).innerProduct(a6) / (a2 * a2);
        if (a7 < 0.0) {
            return p.distance(this.goto);
        }
        if (a7 > 1.0) {
            return p.distance(this.enum);
        }
        Point a8 = new Point(a3.add(a6.scaled(a7)));
        return p.distance(a8);
    }

    private void do(Point a2) {
        LineSegment a3;
        ArgumentAssertion.assertTrue(a2.dimension() == a3.dimension(), "dimensions of the point(%d) and the line segment(%d) must match", a2.dimension(), a3.dimension());
    }

    public Point getEndPoint2() {
        return this.enum;
    }

    public LineSegment(Point p1, Point p2) {
        ArgumentAssertion.assertTrue(p1.dimension() == p2.dimension(), "dimensions of p1(%d) and p2(%d) must match", p1.dimension(), p2.dimension());
        this.goto = p1;
        this.enum = p2;
    }

    public int dimension() {
        return this.goto.dimension();
    }
}

