/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.special.gamma;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.number.DoubleUtils;

public class GammaGergoNemes
extends AbstractUnivariateRealFunction
implements Gamma {
    @Override
    public double evaluate(double x) {
        if (DoubleUtils.isZero(x, 0.0)) {
            return Double.POSITIVE_INFINITY;
        }
        double a2 = x > 0.0 ? x : -x;
        double a3 = Math.sqrt(Math.PI * 2 / a2);
        double a4 = (a2 + 1.0 / (12.0 * a2 - 0.1 * a2)) / Math.E;
        double a5 = Math.pow(a4, a2);
        double a6 = a3 * a5;
        a6 = x > 0.0 ? a6 : GammaLanczosQuick.reflectionFormula(-x, a6);
        return a6;
    }
}

