/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.function.polynomial.root;

import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.polynomial.root.CubicRoot;
import dev.nm.analysis.function.polynomial.root.LinearRoot;
import dev.nm.analysis.function.polynomial.root.PolyRootSolver;
import dev.nm.analysis.function.polynomial.root.QuadraticRoot;
import dev.nm.analysis.function.polynomial.root.QuarticRoot;
import dev.nm.analysis.function.polynomial.root.jenkinstraub.JenkinsTraubReal;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.NumberUtils;
import dev.nm.number.complex.Complex;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PolyRoot
implements PolyRootSolver {
    private final QuarticRoot const;
    private final QuadraticRoot void;
    private final CubicRoot class;
    private final LinearRoot goto = new LinearRoot();
    private final JenkinsTraubReal enum;

    public static List<Double> getRealRoots(List<? extends Number> roots) {
        ArrayList<Double> a2 = new ArrayList<Double>();
        for (Number number : roots) {
            if (!NumberUtils.isReal(number)) continue;
            a2.add((Double)number);
        }
        return a2;
    }

    public PolyRoot() {
        this.void = new QuadraticRoot();
        this.class = new CubicRoot();
        this.const = new QuarticRoot();
        this.enum = new JenkinsTraubReal();
    }

    public static List<Complex> getComplexRoots(List<? extends Number> roots) {
        ArrayList<Complex> a2 = new ArrayList<Complex>();
        for (Number number : roots) {
            if (NumberUtils.isReal(number)) continue;
            a2.add((Complex)number);
        }
        return a2;
    }

    @Override
    public List<? extends Number> solve(Polynomial polynomial) {
        ArgumentAssertion.assertTrue(polynomial.degree() != 0, "this polynomial is a constant %f", polynomial.getCoefficient(0));
        int a2 = polynomial.degree();
        switch (a2) {
            case 1: {
                return this.goto.solve(polynomial);
            }
            case 2: {
                return this.void.solve(polynomial);
            }
            case 3: {
                return this.class.solve(polynomial);
            }
            case 4: {
                return this.const.solve(polynomial);
            }
        }
        return this.enum.solve(polynomial);
    }
}

