/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.differentialequation.ode.ivp.problem.DerivativeFunction;
import dev.nm.analysis.differentialequation.ode.ivp.problem.ODE1stOrder;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODEIntegrator;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolution;
import dev.nm.analysis.differentialequation.ode.ivp.solver.ODESolver;
import dev.nm.analysis.differentialequation.ode.ivp.solver.multistep.adamsbashforthmoulton.ABMPredictorCorrector;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKutta2;
import dev.nm.analysis.differentialequation.ode.ivp.solver.rungekutta.RungeKuttaIntegrator;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AdamsBashforthMoulton
implements ODESolver {
    private final double class;
    private final ODEIntegrator goto;
    private final ABMPredictorCorrector enum;

    private static double[] do(double[] a2, int a3, int a4) {
        double[] a5 = new double[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize) {
        this(predictorCorrector, stepSize, new RungeKuttaIntegrator(new RungeKutta2()));
    }

    @Override
    public ODESolution solve(ODE1stOrder ode) {
        int a2;
        Object a3;
        double a4;
        int a5 = this.enum.order();
        ArgumentAssertion.assertTrue((double)a5 * this.class < (a4 = ode.x1() - ode.x0()), "the initialization exhausts the range for the approximation; select a smaller step size or order, or a larger range", new Object[0]);
        int a6 = (int)(a4 / this.class) + 1;
        double[] a7 = new double[a6];
        Vector[] a8 = new Vector[a6];
        if (a5 > 1) {
            a3 = new double[a5];
            for (a2 = 0; a2 < a5; ++a2) {
                a3[a2] = this.class * (double)a2;
            }
            System.arraycopy(a3, 0, a7, 0, a5);
            System.arraycopy(this.goto.integrate(ode, (double[])a3), 0, a8, 0, a5);
        } else {
            a7[0] = 0.0;
            a8[0] = ode.y0();
        }
        a3 = ode.dy();
        for (a2 = a5 - 1; a2 < a6 - 1; ++a2) {
            Vector a9;
            double[] a10 = AdamsBashforthMoulton.do(a7, a2, a5);
            Vector[] a11 = AdamsBashforthMoulton.do(a8, a2, a5);
            Vector a12 = this.enum.predict((DerivativeFunction)a3, this.class, a10, a11);
            a7[a2 + 1] = a7[a2] + this.class;
            a8[a2 + 1] = a12;
            a10 = AdamsBashforthMoulton.do(a7, a2 + 1, a5 + 1);
            a11 = AdamsBashforthMoulton.do(a8, a2 + 1, a5 + 1);
            a8[a2 + 1] = a9 = this.enum.correct((DerivativeFunction)a3, this.class, a10, a11);
        }
        return new ODESolution(a7, a8);
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    private static Vector[] do(Vector[] a2, int a3, int a4) {
        Vector[] a5 = new Vector[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2[a3 - a6];
        }
        return a5;
    }

    public AdamsBashforthMoulton(ABMPredictorCorrector predictorCorrector, double stepSize, ODEIntegrator integrator) {
        this.enum = predictorCorrector;
        this.class = stepSize;
        this.goto = integrator;
    }
}

