/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.curvefit;

import dev.nm.analysis.curvefit.CurveFitting;
import dev.nm.analysis.function.FunctionOps;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.tuple.OrderedPairs;
import dev.nm.analysis.function.tuple.SortedOrderedPairs;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LeastSquares
implements CurveFitting {
    private final int goto;
    public static final Weighting UNIFORM_WEIGHTING;
    private final Weighting enum;

    private double[] do(double[] a2, double[] a3) {
        double[] a4 = new double[a2.length];
        for (int a5 = 0; a5 < a4.length; ++a5) {
            LeastSquares a6;
            a4[a5] = a6.enum.getWeightForObservation(a2[a5], a3[a5]);
        }
        return a4;
    }

    public LeastSquares(int m2) {
        this(m2, UNIFORM_WEIGHTING);
    }

    public LeastSquares(int m2, Weighting weighting) {
        ArgumentAssertion.assertNonNegative(m2, "the maximum degree");
        this.goto = m2 + 1;
        this.enum = weighting;
    }

    static {
        Package.validate("NMDEV_BASIC");
        UNIFORM_WEIGHTING = new Weighting(){

            @Override
            public double getWeightForObservation(double x, double y) {
                return 1.0;
            }
            {
                1 a2;
            }
        };
    }

    @Override
    public UnivariateRealFunction fit(OrderedPairs f2) {
        int a2 = f2.size();
        ArgumentAssertion.assertNotLessThan(a2, this.goto, "the number of points");
        SortedOrderedPairs a3 = new SortedOrderedPairs(f2);
        double[] a4 = a3.x();
        double[] a5 = a3.y();
        double[] a6 = this.do(a4, a5);
        double[] a7 = new double[this.goto];
        final double[] a8 = new double[this.goto];
        a7[0] = DoubleArrayMath.sum(a6);
        a8[0] = FunctionOps.dotProduct(a6, a4) / a7[0];
        double[][] a9 = new double[this.goto][a2];
        for (int a10 = 0; a10 < a2; ++a10) {
            a9[0][a10] = 1.0;
            a9[1][a10] = a4[a10] - a8[0];
        }
        final double[] a11 = new double[this.goto];
        for (int a12 = 1; a12 < this.goto; ++a12) {
            int a13;
            double a14 = 0.0;
            double a15 = 0.0;
            double a16 = 0.0;
            for (a13 = 0; a13 < a2; ++a13) {
                double a17 = a9[a12][a13] * a9[a12][a13];
                double a18 = a4[a13] * a6[a13];
                a14 += a17 * a6[a13];
                a15 += a17 * a18;
                a16 += a18 * a9[a12][a13] * a9[a12 - 1][a13];
            }
            a7[a12] = a14;
            a8[a12] = a15 /= a14;
            a11[a12] = a16 /= a7[a12 - 1];
            if (a12 >= this.goto - 1) continue;
            for (a13 = 0; a13 < a2; ++a13) {
                a9[a12 + 1][a13] = (a4[a13] - a15) * a9[a12][a13] - a16 * a9[a12 - 1][a13];
            }
        }
        final double[] a19 = new double[this.goto];
        for (int a20 = 0; a20 < this.goto; ++a20) {
            a19[a20] = FunctionOps.dotProduct(a5, a9[a20]) / a7[a20];
        }
        return new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double alpha) {
                double[] a2 = new double[LeastSquares.this.goto];
                a2[0] = 1.0;
                a2[1] = alpha - a8[0];
                for (int a3 = 1; a3 < LeastSquares.this.goto - 1; ++a3) {
                    a2[a3 + 1] = (alpha - a8[a3]) * a2[a3] - a11[a3] * a2[a3 - 1];
                }
                double a4 = FunctionOps.dotProduct(a19, a2);
                return a4;
            }
            {
                2 a3;
            }
        };
    }

    public static interface Weighting {
        public double getWeightForObservation(double var1, double var3);
    }
}

