/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SubMatrixRef
implements Matrix {
    private static final MatrixMathOperation void = new AutoParallelMatrixMathOperation();
    private final int[] class;
    private final int[] goto;
    private final Matrix enum;

    @Override
    public int nRows() {
        return this.class.length;
    }

    @Override
    public Matrix multiply(Matrix that) {
        return void.multiply((MatrixAccess)this, that);
    }

    @Override
    public Vector multiply(Vector v) {
        return void.multiply((MatrixAccess)this, v);
    }

    @Override
    public Matrix t() {
        return new DenseMatrix(this).t();
    }

    @Override
    public Matrix ONE() {
        return new DenseMatrix(this.nRows(), this.nCols()).ONE();
    }

    public String toString() {
        return new DenseMatrix(this).toString();
    }

    public SubMatrixRef(Matrix A2, int rowFrom, int rowTo, int colFrom, int colTo) {
        this(A2, DoubleUtils.seq(rowFrom, rowTo, 1), DoubleUtils.seq(colFrom, colTo, 1));
    }

    @Override
    public Matrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols()).ZERO();
    }

    @Override
    public SubMatrixRef deepCopy() {
        return this;
    }

    @Override
    public Matrix scaled(double scalar) {
        return new DenseMatrix(this).scaled(scalar);
    }

    public SubMatrixRef(Matrix A2) {
        this(A2, 1, A2.nRows(), 1, A2.nCols());
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public Matrix add(Matrix that) {
        return void.add(this, that);
    }

    @Override
    public int nCols() {
        return this.goto.length;
    }

    @Override
    @Deprecated
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new MatrixAccessException("SubMatrixRef is immutable.");
    }

    @Override
    public Vector getRow(int i2) {
        Vector a2 = this.enum.getRow(this.class[i2 - 1]);
        Vector a3 = VectorFactory.subVector(a2, this.goto);
        return a3;
    }

    @Override
    public double get(int i2, int j2) {
        return this.enum.get(this.class[i2 - 1], this.goto[j2 - 1]);
    }

    @Override
    public Vector getColumn(int j2) {
        Vector a2 = this.enum.getColumn(this.goto[j2 - 1]);
        Vector a3 = VectorFactory.subVector(a2, this.class);
        return a3;
    }

    public SubMatrixRef(Matrix A2, int[] rows, int[] cols) {
        this.enum = A2;
        this.class = Arrays.copyOf(rows, rows.length);
        this.goto = Arrays.copyOf(cols, cols.length);
    }

    @Override
    public Matrix minus(Matrix that) {
        return void.minus(this, that);
    }
}

