/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.DOKSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.LILSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.operation.positivedefinite.GoldfeldQuandtTrotter;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import dev.nm.stat.random.rng.RNGUtils;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MatrixFactory {
    public static Matrix foreachColumn(Matrix matrix, RealVectorFunction f2) {
        Vector[] a2 = MatrixUtils.toColumns(matrix);
        return MatrixFactory.cbind(VectorFactory.foreachVector(a2, f2));
    }

    public static LowerTriangularMatrix randomLowerTriangularMatrix(int dim, RandomNumberGenerator rng) {
        double[][] a2 = new double[dim][];
        for (int a3 = 0; a3 < dim; ++a3) {
            a2[a3] = new double[a3 + 1];
            for (int a4 = 0; a4 <= a3; ++a4) {
                a2[a3][a4] = rng.nextDouble();
            }
        }
        return new LowerTriangularMatrix(a2);
    }

    public static Matrix ones(int nRows, int nCols, double s) {
        DenseMatrix a2 = new DenseMatrix(DoubleUtils.rep(s, nRows * nCols), nRows, nCols);
        return a2;
    }

    public static Matrix rbind(Matrix ... matrices) {
        if (matrices == null || matrices.length == 0 || Arrays.stream(matrices).allMatch(Objects::isNull)) {
            return null;
        }
        if (MatrixPropertyUtils.areAllSparse(matrices)) {
            return MatrixFactory.rbind((SparseMatrix[])Arrays.copyOf(matrices, matrices.length, SparseMatrix[].class));
        }
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        for (Matrix a3 : matrices) {
            if (a3 == null || a3.nRows() <= 0) continue;
            for (int a4 = 1; a4 <= a3.nRows(); ++a4) {
                a2.add(a3.getRow(a4));
            }
        }
        return MatrixFactory.rbind(a2);
    }

    public static SymmetricMatrix randomSymmetricMatrix(int dim, RandomNumberGenerator rng) {
        double[][] a2 = new double[dim][];
        for (int a3 = 0; a3 < dim; ++a3) {
            a2[a3] = new double[a3 + 1];
            for (int a4 = 0; a4 <= a3; ++a4) {
                a2[a3][a4] = rng.nextDouble();
            }
        }
        return new SymmetricMatrix(a2);
    }

    public static Matrix cbind(List<Vector> vectors) {
        return MatrixFactory.cbind(vectors.toArray(new Vector[0]));
    }

    public static DOKSparseMatrix randomDOKSparseMatrix(int nRows, int nCols, int nNonZero, RandomLongGenerator uniform) {
        List<SparseMatrix.Entry> a2 = MatrixFactory.do(nRows, nCols, nNonZero, uniform);
        return new DOKSparseMatrix(nRows, nCols, a2);
    }

    public static Matrix columns(Matrix A2, int begin, int end) {
        return MatrixFactory.columns(A2, DoubleUtils.seq(begin, end));
    }

    public static Matrix cbind(Matrix ... matrices) {
        if (matrices == null || matrices.length == 0 || Arrays.stream(matrices).allMatch(Objects::isNull)) {
            return null;
        }
        if (MatrixPropertyUtils.areAllSparse(matrices)) {
            return MatrixFactory.cbind((SparseMatrix[])Arrays.copyOf(matrices, matrices.length, SparseMatrix[].class));
        }
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        for (Matrix a3 : matrices) {
            if (a3 == null || a3.nCols() <= 0) continue;
            for (int a4 = 1; a4 <= a3.nCols(); ++a4) {
                a2.add(a3.getColumn(a4));
            }
        }
        return MatrixFactory.cbind(a2);
    }

    public static Matrix rbind(List<Vector> vectors) {
        int a2 = vectors.size();
        Vector[] a3 = new Vector[a2];
        for (int a4 = 0; a4 < a2; ++a4) {
            a3[a4] = vectors.get(a4);
        }
        return MatrixFactory.rbind(a3);
    }

    public static SparseMatrix cbind(SparseMatrix ... matrices) {
        Object a2;
        if (matrices == null || matrices.length == 0 || Arrays.stream(matrices).allMatch(Objects::isNull)) {
            return null;
        }
        int a3 = -1;
        int a4 = 0;
        int a5 = 0;
        int[] a6 = new int[matrices.length];
        int[] a7 = new int[matrices.length];
        for (int a8 = 0; a8 < matrices.length; ++a8) {
            a2 = matrices[a8];
            if (a2 == null) continue;
            a7[a8] = a4;
            a6[a8] = a5;
            a4 += a2.nCols();
            a5 += a2.nNonZeros();
            if (a3 < 0) {
                a3 = a2.nRows();
                continue;
            }
            if (a2.nRows() == a3) continue;
            throw new IllegalArgumentException("matrices have inconsistent row counts");
        }
        int[] a9 = new int[a5];
        a2 = new int[a5];
        double[] a10 = new double[a5];
        IntStream.range(0, matrices.length).parallel().forEach(arg_0 -> MatrixFactory.do(matrices, a6, a7, a9, a10, (int[])a2, arg_0));
        if (MatrixFactory.do(LILSparseMatrix.class, matrices)) {
            return new LILSparseMatrix(a3, a4, a9, (int[])a2, a10);
        }
        if (MatrixFactory.do(DOKSparseMatrix.class, matrices)) {
            return new DOKSparseMatrix(a3, a4, a9, (int[])a2, a10);
        }
        return new CSRSparseMatrix(a3, a4, a9, (int[])a2, a10);
    }

    public static Matrix identity(int nRows, int nCols) {
        DenseMatrix a2 = new DenseMatrix(nRows, nCols);
        int a3 = Math.min(nRows, nCols);
        for (int a4 = 1; a4 <= a3; ++a4) {
            a2.set(a4, a4, 1.0);
        }
        return a2;
    }

    public static Matrix rows(Matrix A2, int begin, int end) {
        return MatrixFactory.rows(A2, DoubleUtils.seq(begin, end));
    }

    public static Matrix subMatrix(Matrix A2, List<Integer> rows, List<Integer> cols) {
        return MatrixFactory.subMatrix(A2, DoubleUtils.collection2IntArray(rows), DoubleUtils.collection2IntArray(cols));
    }

    public static SparseMatrix subMatrix(SparseMatrix A2, int[] rows, int[] cols) {
        SparseMatrix a2;
        if (A2 instanceof LILSparseMatrix) {
            a2 = new LILSparseMatrix(rows.length, cols.length);
        } else if (A2 instanceof CSRSparseMatrix) {
            a2 = new CSRSparseMatrix(rows.length, cols.length);
        } else if (A2 instanceof DOKSparseMatrix) {
            a2 = new DOKSparseMatrix(rows.length, cols.length);
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        for (int a3 = 0; a3 < rows.length; ++a3) {
            for (int a4 = 0; a4 < cols.length; ++a4) {
                a2.set(a3 + 1, a4 + 1, A2.get(rows[a3], cols[a4]));
            }
        }
        return a2;
    }

    public static Matrix foreach(Matrix A2, UnivariateRealFunction f2) {
        if (!(A2 instanceof SparseMatrix)) {
            double[] a2 = MatrixUtils.to1DArray(A2);
            return new DenseMatrix(DoubleUtils.foreach(a2, f2), A2.nRows(), A2.nCols());
        }
        double a3 = f2.evaluate(0.0);
        List<SparseMatrix.Entry> a4 = ((SparseMatrix)A2).getEntryList();
        if (a3 == 0.0) {
            Matrix a5 = A2.ZERO();
            for (SparseMatrix.Entry a6 : a4) {
                MatrixCoordinate a7 = a6.coordinates;
                a5.set(a7.i, a7.j, f2.evaluate(a6.value));
            }
            return a5;
        }
        int a8 = A2.nRows();
        int a9 = A2.nCols();
        int[] a10 = new int[a8 * a9];
        int[] a11 = new int[a8 * a9];
        for (int a12 = 0; a12 < a8 * a9; ++a12) {
            a10[a12] = a12 / a9 + 1;
            a11[a12] = a12 % a9 + 1;
        }
        double[] a13 = new double[a8 * a9];
        Arrays.fill(a13, a3);
        for (SparseMatrix.Entry a14 : a4) {
            int a15 = (a14.coordinates.i - 1) * a9 + a14.coordinates.j - 1;
            a13[a15] = f2.evaluate(a14.value);
        }
        if (A2 instanceof LILSparseMatrix) {
            return new LILSparseMatrix(a8, a9, a10, a11, a13);
        }
        if (A2 instanceof CSRSparseMatrix) {
            return new CSRSparseMatrix(a8, a9, a10, a11, a13);
        }
        if (A2 instanceof DOKSparseMatrix) {
            return new DOKSparseMatrix(a8, a9, a10, a11, a13);
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static List<SparseMatrix.Entry> do(int a2, int a3, int a4, RandomLongGenerator a5) {
        int a6 = a2 * a3;
        ArgumentAssertion.assertTrue(a6 >= a4, "the number of non-zeros cannot be greater than the matrix size", new Object[0]);
        HashSet<Long> a7 = new HashSet<Long>(a4 * 2);
        ArrayList<SparseMatrix.Entry> a8 = new ArrayList<SparseMatrix.Entry>(a4);
        for (int a9 = 0; a9 < a4; ++a9) {
            long a10;
            double a11 = a5.nextDouble();
            while (a7.contains(a10 = a5.nextLong() % (long)a6)) {
            }
            a7.add(a10);
            int a12 = (int)(a10 / (long)a3 + 1L);
            int a13 = (int)(a10 % (long)a3 + 1L);
            SparseMatrix.Entry a14 = new SparseMatrix.Entry(new MatrixCoordinate(a12, a13), a11);
            a8.add(a14);
        }
        return a8;
    }

    public static CSRSparseMatrix randomCSRSparseMatrix(int nRows, int nCols, int nNonZero, RandomLongGenerator uniform) {
        List<SparseMatrix.Entry> a2 = MatrixFactory.do(nRows, nCols, nNonZero, uniform);
        return new CSRSparseMatrix(nRows, nCols, a2);
    }

    public static Matrix minorMatrix(Matrix X, final int row, final int col) {
        int[] a2 = DoubleUtils.select(DoubleUtils.seq(1, X.nRows()), new DoubleUtils.which(){

            @Override
            public boolean isTrue(double x, int index) {
                return index + 1 != row;
            }
            {
                1 a2;
            }
        });
        int[] a3 = DoubleUtils.select(DoubleUtils.seq(1, X.nCols()), new DoubleUtils.which(){

            @Override
            public boolean isTrue(double x, int index) {
                return index + 1 != col;
            }
            {
                2 a2;
            }
        });
        Matrix a4 = MatrixFactory.subMatrix(X, a2, a3);
        return a4;
    }

    public static Matrix subMatrix(Matrix A2, int[] rows, int[] cols) {
        if (A2 instanceof SparseMatrix) {
            return MatrixFactory.subMatrix((SparseMatrix)A2, rows, cols);
        }
        int a2 = rows.length;
        int a3 = cols.length;
        double[] a4 = new double[a2 * a3];
        int a5 = 0;
        int a6 = 0;
        while (a5 < a2) {
            for (int a7 = 0; a7 < a3; ++a7) {
                a4[a6 + a7] = A2.get(rows[a5], cols[a7]);
            }
            ++a5;
            a6 += a3;
        }
        DenseMatrix a22 = new DenseMatrix(a4, a2, a3);
        return a22;
    }

    public static SparseMatrix rbind(SparseVector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        int a2 = MatrixFactory.do(vectors);
        int a3 = 0;
        int a4 = 0;
        for (SparseVector a5 : vectors) {
            if (a5 == null) continue;
            ++a3;
            a4 += a5.nNonZeros();
        }
        int a6 = 1;
        ArrayList<SparseMatrix.Entry> a7 = new ArrayList<SparseMatrix.Entry>(a4);
        for (SparseVector a8 : vectors) {
            if (a8 == null) continue;
            for (SparseVector.Entry a9 : a8) {
                a7.add(new SparseMatrix.Entry(new MatrixCoordinate(a6, a9.index()), a9.value()));
            }
            ++a6;
        }
        return new CSRSparseMatrix(a3, a2, a7);
    }

    public static Matrix ones(int nRows, int nCols) {
        return MatrixFactory.ones(nRows, nCols, 1.0);
    }

    private MatrixFactory() {
        MatrixFactory a2;
    }

    public static Matrix rbind(Vector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        if (MatrixPropertyUtils.areAllSparse(vectors)) {
            return MatrixFactory.rbind((SparseVector[])Arrays.copyOf(vectors, vectors.length, SparseVector[].class));
        }
        List<Vector> a3 = Arrays.asList(vectors).stream().filter(a2 -> a2 != null).collect(Collectors.toList());
        int a4 = a3.size();
        int a6 = MatrixFactory.do(a3.toArray(new Vector[a4]));
        double[] a7 = new double[a4 * a6];
        IntStream.range(0, a4).parallel().forEach(a5 -> {
            Vector a6 = (Vector)a3.get(a5);
            System.arraycopy(a6.toArray(), 0, a7, a5 * a6, a6);
        });
        return new DenseMatrix(a7, a4, a6);
    }

    public static UpperTriangularMatrix randomUpperTriangularMatrix(int dim, RandomNumberGenerator rng) {
        LowerTriangularMatrix a2 = MatrixFactory.randomLowerTriangularMatrix(dim, rng);
        return a2.t();
    }

    public static Matrix foreachRow(Matrix A2, RealVectorFunction f2) {
        Vector[] a2 = MatrixUtils.toRows(A2);
        return MatrixFactory.rbind(VectorFactory.foreachVector(a2, f2));
    }

    public static Matrix rows(Matrix A2, int[] rows) {
        return MatrixFactory.subMatrix(A2, rows, DoubleUtils.seq(1, A2.nCols()));
    }

    public static Matrix replaceInPlace(Matrix original, int rowFrom, int rowTo, int colFrom, int colTo, Matrix replacement) {
        int a2 = rowTo - rowFrom + 1;
        int a3 = colTo - colFrom + 1;
        ArgumentAssertion.assertTrue(rowFrom <= rowTo, "invalid row indices", new Object[0]);
        ArgumentAssertion.assertTrue(colFrom <= colTo, "invalid column indices", new Object[0]);
        ArgumentAssertion.assertTrue(replacement.nRows() == a2, "the replacement matrix does not have %d rows", a2);
        ArgumentAssertion.assertTrue(replacement.nCols() == a3, "the replacement matrix does not have %d columns", a3);
        ArgumentAssertion.assertTrue(rowTo <= original.nRows(), "rowTo exceeds the boundary", new Object[0]);
        ArgumentAssertion.assertTrue(colTo <= original.nCols(), "colTo exceeds the boundary", new Object[0]);
        int a4 = 1;
        int a5 = rowFrom;
        while (a4 <= a2) {
            int a6 = 1;
            int a7 = colFrom;
            while (a6 <= a3) {
                original.set(a5, a7, replacement.get(a4, a6));
                ++a6;
                ++a7;
            }
            ++a4;
            ++a5;
        }
        return original;
    }

    public static Matrix columns(Matrix A2, int[] cols) {
        return MatrixFactory.subMatrix(A2, DoubleUtils.seq(1, A2.nRows()), cols);
    }

    public static Matrix subMatrix(Matrix A2, int rowFrom, int rowTo, int colFrom, int colTo) {
        if (A2 instanceof SparseMatrix) {
            return MatrixFactory.subMatrix((SparseMatrix)A2, rowFrom, rowTo, colFrom, colTo);
        }
        int a2 = rowTo - rowFrom + 1;
        int a3 = colTo - colFrom + 1;
        double[] a4 = new double[a2 * a3];
        int a5 = 0;
        for (int a6 = rowFrom; a6 <= rowTo; ++a6) {
            for (int a7 = colFrom; a7 <= colTo; ++a7) {
                a4[a5++] = A2.get(a6, a7);
            }
        }
        return new DenseMatrix(a4, a2, a3);
    }

    private static boolean do(Class<? extends SparseMatrix> a2, SparseMatrix ... a3) {
        for (SparseMatrix a4 : a3) {
            if (a4 == null || a4.getClass() == a2) continue;
            return false;
        }
        return true;
    }

    private static int do(Vector ... a2) {
        int a3 = -2147483647;
        for (Vector a4 : a2) {
            if (a4 == null) continue;
            if (a3 < 0) {
                a3 = a4.size();
            }
            ArgumentAssertion.assertTrue(a4.size() == a3, "all vectors must be of the same size", new Object[0]);
        }
        return a3;
    }

    public static SparseMatrix rbind(SparseMatrix ... matrices) {
        if (matrices == null || matrices.length == 0 || Arrays.stream(matrices).allMatch(Objects::isNull)) {
            return null;
        }
        boolean a2 = true;
        int a3 = 0;
        int a4 = 0;
        int a5 = 0;
        for (SparseMatrix a6 : matrices) {
            if (a6 == null) continue;
            a4 += a6.nRows();
            a5 += a6.nNonZeros();
            if (!a2) continue;
            a2 = false;
            a3 = a6.nCols();
        }
        ArrayList<SparseMatrix.Entry> a7 = new ArrayList<SparseMatrix.Entry>(a5);
        int a8 = 0;
        for (SparseMatrix a9 : matrices) {
            if (a9 == null) continue;
            if (a9.nCols() != a3) {
                throw new IllegalArgumentException("matrices not aligned in columns");
            }
            List<SparseMatrix.Entry> a10 = a9.getEntryList();
            if (!a10.isEmpty()) {
                for (SparseMatrix.Entry a11 : a10) {
                    MatrixCoordinate a12 = a11.coordinates;
                    a7.add(new SparseMatrix.Entry(new MatrixCoordinate(a12.i + a8, a12.j), a11.value));
                }
            }
            a8 += a9.nRows();
        }
        if (MatrixFactory.do(LILSparseMatrix.class, matrices)) {
            return new LILSparseMatrix(a4, a3, a7);
        }
        if (MatrixFactory.do(DOKSparseMatrix.class, matrices)) {
            return new DOKSparseMatrix(a4, a3, a7);
        }
        return new CSRSparseMatrix(a4, a3, a7);
    }

    public static LILSparseMatrix randomLILSparseMatrix(int nRows, int nCols, int nNonZero, RandomLongGenerator uniform) {
        List<SparseMatrix.Entry> a2 = MatrixFactory.do(nRows, nCols, nNonZero, uniform);
        return new LILSparseMatrix(nRows, nCols, a2);
    }

    public static DiagonalMatrix diagonalMatrix(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "only a square matrix has a diagonal matrix", new Object[0]);
        double[] a2 = new double[A2.nRows()];
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            a2[a3 - 1] = A2.get(a3, a3);
        }
        return new DiagonalMatrix(a2);
    }

    public static SparseMatrix cbind(SparseVector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        int a2 = MatrixFactory.do(vectors);
        int a3 = 0;
        int a4 = 0;
        for (SparseVector a5 : vectors) {
            if (a5 == null) continue;
            ++a3;
            a4 += a5.nNonZeros();
        }
        int a6 = 1;
        ArrayList<SparseMatrix.Entry> a7 = new ArrayList<SparseMatrix.Entry>(a4);
        for (SparseVector a8 : vectors) {
            if (a8 == null) continue;
            for (SparseVector.Entry a9 : a8) {
                a7.add(new SparseMatrix.Entry(new MatrixCoordinate(a9.index(), a6), a9.value()));
            }
            ++a6;
        }
        return new CSRSparseMatrix(a2, a3, a7);
    }

    public static Matrix randomPositiveDefiniteMatrix(int dim, RandomNumberGenerator rng) {
        DenseMatrix a2 = MatrixFactory.randomDenseMatrix(dim, dim, rng);
        SampleCovariance a3 = new SampleCovariance((Matrix)a2);
        GoldfeldQuandtTrotter a4 = new GoldfeldQuandtTrotter((Matrix)a3, 1.0E-8);
        return a4;
    }

    public static Matrix cbind(Vector ... vectors) {
        if (vectors == null || vectors.length == 0 || Arrays.stream(vectors).allMatch(Objects::isNull)) {
            return null;
        }
        if (MatrixPropertyUtils.areAllSparse(vectors)) {
            return MatrixFactory.cbind((SparseVector[])Arrays.copyOf(vectors, vectors.length, SparseVector[].class));
        }
        int a2 = MatrixFactory.do(vectors);
        int a3 = vectors.length;
        double[] a4 = new double[a2 * a3];
        int a5 = 0;
        for (Vector a6 : vectors) {
            if (a6 != null) {
                System.arraycopy(a6.toArray(), 0, a4, a5, a2);
            }
            a5 += a2;
        }
        return new DenseMatrix(a4, a3, a2).t();
    }

    private static /* synthetic */ void do(SparseMatrix[] a2, int[] a3, int[] a4, int[] a5, double[] a6, int[] a7, int a8) {
        SparseMatrix a9 = a2[a8];
        if (a9 == null) {
            return;
        }
        SparseMatrix.ValueArray a10 = a9.getValueArray();
        int a11 = a9.nNonZeros();
        int a12 = a3[a8];
        int a13 = a4[a8];
        System.arraycopy(a10.rowIndices(), 0, a5, a12, a11);
        System.arraycopy(a10.values(), 0, a6, a12, a11);
        int[] a14 = a10.columnIndices();
        for (int a15 = 0; a15 < a11; ++a15) {
            a7[a12 + a15] = a14[a15] + a13;
        }
    }

    public static SparseMatrix subMatrix(SparseMatrix A2, int rowFrom, int rowTo, int colFrom, int colTo) {
        return A2.subMatrix(rowFrom, rowTo, colFrom, colTo);
    }

    public static DenseMatrix randomDenseMatrix(int nRows, int nCols, RandomNumberGenerator rng) {
        double[] a2 = RNGUtils.nextN(rng, nRows * nCols);
        return new DenseMatrix(a2, nRows, nCols);
    }
}

