/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixTable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ElementaryOperation
implements MatrixTable {
    private final Vector[] class;
    private final int goto;
    private final int enum;

    public ElementaryOperation(Matrix A2) {
        this.goto = A2.nRows();
        this.enum = A2.nCols();
        this.class = new Vector[this.goto];
        for (int a2 = 1; a2 <= this.goto; ++a2) {
            this.class[a2 - 1] = A2.getRow(a2);
        }
    }

    public Matrix T() {
        return MatrixFactory.rbind(this.class);
    }

    @Override
    public double get(int i2, int j2) {
        return this.class[i2 - 1].get(j2);
    }

    public ElementaryOperation addRow(int i1, int i2, double c2) {
        Vector a2 = this.class[i1 - 1];
        Vector a3 = this.class[i2 - 1];
        for (int a4 = 1; a4 <= this.enum; ++a4) {
            a2.set(a4, a2.get(a4) + c2 * a3.get(a4));
        }
        return this;
    }

    @Override
    public int nCols() {
        return this.enum;
    }

    @Override
    public int nRows() {
        return this.goto;
    }

    public String toString() {
        return this.T().toString();
    }

    public ElementaryOperation addColumn(int j1, int j2, double c2) {
        for (Vector a2 : this.class) {
            a2.set(j1, a2.get(j1) + c2 * a2.get(j2));
        }
        return this;
    }

    public ElementaryOperation scaleColumn(int j2, double c2) {
        for (Vector a2 : this.class) {
            a2.set(j2, c2 * a2.get(j2));
        }
        return this;
    }

    public ElementaryOperation swapRow(int i1, int i2) {
        Vector a2 = this.class[i1 - 1];
        this.class[i1 - 1] = this.class[i2 - 1];
        this.class[i2 - 1] = a2;
        return this;
    }

    @Override
    @Deprecated
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        throw new UnsupportedOperationException("please use the elementary operations");
    }

    public ElementaryOperation(int nRows, int nCols) {
        this((Matrix)new DenseMatrix(nRows, nCols).ONE());
    }

    public ElementaryOperation(int dim) {
        this(dim, dim);
    }

    public ElementaryOperation swapColumn(int j1, int j2) {
        for (Vector a2 : this.class) {
            double a3 = a2.get(j1);
            a2.set(j1, a2.get(j2));
            a2.set(j2, a3);
        }
        return this;
    }

    public ElementaryOperation scaleRow(int i2, double c2) {
        Vector a2 = this.class[i2 - 1];
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            a2.set(a3, c2 * a2.get(a3));
        }
        return this;
    }
}

