/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.operation;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DiagonalSum
implements Matrix {
    private final Matrix enum;

    @Override
    public int nRows() {
        return this.enum.nRows();
    }

    public DiagonalSum(Matrix A2, double d2) {
        this(A2, DoubleUtils.rep(d2, A2.nCols()));
    }

    public DiagonalSum(Matrix A2, Vector d2) {
        this(A2, d2.toArray());
    }

    @Override
    public Matrix multiply(Matrix that) {
        return this.enum.multiply(that);
    }

    @Override
    public Vector getRow(int i2) throws MatrixAccessException {
        return this.enum.getRow(i2);
    }

    @Override
    public Matrix add(Matrix that) {
        return this.enum.add(that);
    }

    @Override
    public Matrix ZERO() {
        return this.enum.ZERO();
    }

    @Override
    public Matrix scaled(double c2) {
        return this.enum.scaled(c2);
    }

    @Override
    public int nCols() {
        return this.enum.nCols();
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        return this.enum.get(i2, j2);
    }

    @Override
    public Matrix deepCopy() {
        return this.enum.deepCopy();
    }

    @Override
    public Matrix t() {
        return this.enum.t();
    }

    @Override
    public Vector multiply(Vector v) {
        return this.enum.multiply(v);
    }

    @Override
    public Matrix minus(Matrix that) {
        return this.enum.minus(that);
    }

    public DiagonalSum(Matrix A2, double[] d2) {
        ArgumentAssertion.assertTrue(A2.nCols() == A2.nRows(), "A must be a square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(A2.nCols() == d2.length, "A and d dimensions must match", new Object[0]);
        Matrix a2 = A2.deepCopy();
        int a3 = A2.nCols();
        for (int a4 = 1; a4 <= a3; ++a4) {
            double a5 = A2.get(a4, a4) + d2[a4 - 1];
            a2.set(a4, a4, a5);
        }
        this.enum = a2;
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        return this.enum.getColumn(j2);
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        this.enum.set(i2, j2, value);
    }

    @Override
    public Matrix ONE() {
        return this.enum.ONE();
    }

    @Override
    public Matrix opposite() {
        return this.enum.opposite();
    }
}

