/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.stationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JacobiSolver
implements IterativeLinearSystemSolver {
    private final Tolerance goto;
    private final int enum;

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(problem.A()), "the matrix A must be square", new Object[0]);
        JacobiSolver.do(problem.A());
        return new IterativeLinearSystemSolver.Solution(){
            boolean isConverged;
            Vector r;
            int count;
            private final Matrix goto;
            Vector x;
            private final Vector enum;
            final int n;

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                monitor.addIterate(this.x);
                Vector a2 = new DenseVector(this.n).ZERO();
                for (int a3 = 1; a3 <= this.n; ++a3) {
                    double a4 = 0.0;
                    for (int a5 = 1; a5 <= this.n; ++a5) {
                        if (a5 == a3) continue;
                        a4 += this.goto.get(a3, a5) * this.x.get(a5);
                    }
                    a4 = (this.enum.get(a3) - a4) / this.goto.get(a3, a3);
                    a2.set(a3, a4);
                }
                this.x = a2;
                this.r = this.enum.minus(this.goto.multiply(this.x));
                return monitor;
            }

            public void setInitials(Vector ... initials) {
                this.x = initials[0];
                this.r = this.enum.minus(this.goto.multiply(this.x));
                this.isConverged = JacobiSolver.this.goto.isResidualSmall(this.r.norm());
            }
            {
                1 a3;
                a3.goto = a3.problem.A();
                a3.enum = a3.problem.b();
                a3.n = a3.problem.size();
                a3.count = 0;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.count < JacobiSolver.this.enum && !this.isConverged) {
                    this.step();
                    ++this.count;
                    this.isConverged |= JacobiSolver.this.goto.isResidualSmall(this.r.norm());
                }
                monitor.addIterate(this.x);
                if (!this.isConverged) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, JacobiSolver.this.enum + " exceeded");
                }
                return this.x;
            }
        };
    }

    private static void do(Matrix a2) {
        for (int a3 = 1; a3 <= a2.nCols(); ++a3) {
            if (Double.compare(a2.get(a3, a3), 0.0) != 0) continue;
            throw new IllegalArgumentException("diagonal entries must be non-zero");
        }
    }

    public JacobiSolver(int maxIteration, Tolerance tolerance) {
        this.enum = maxIteration;
        this.goto = tolerance;
    }

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }
}

