/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.RepeatedCoordinatesException;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrixUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CSRSparseMatrix
implements SparseMatrix {
    private int else;
    private final int catch;
    private double[] const;
    private final int void;
    private static final MatrixMathOperation class = new AutoParallelMatrixMathOperation();
    private CompressedRowPointers goto;
    private int[] enum;

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entries) {
        this(nRows, nCols, entries, false);
    }

    public CSRSparseMatrix(int nRows, int nCols, int[] rowIndices, int[] columnIndices, double[] values) {
        this(nRows, nCols, SparseMatrixUtils.toEntryArray(rowIndices, columnIndices, values), false);
    }

    private void do(CheckForKeptValue a2) {
        CSRSparseMatrix a3;
        int a4 = 0;
        int[] a5 = a3.goto.uncompress();
        for (int a6 = 0; a6 < a3.catch; ++a6) {
            a5[a6] = a4;
            for (int a7 = a5[a6]; a7 < a5[a6 + 1]; ++a7) {
                if (!a2.toKeep(a3.const[a7])) continue;
                a3.const[a4] = a3.const[a7];
                a3.enum[a4] = a3.enum[a7];
                ++a4;
            }
        }
        a5[a3.catch] = a4;
        a3.goto = CompressedRowPointers.fromRowPointers(a5);
        a3.const = Arrays.copyOf(a3.const, a4);
        a3.enum = Arrays.copyOf(a3.enum, a4);
        a3.else = a4;
    }

    public int hashCode() {
        int a2 = 7;
        a2 = 29 * a2 + this.else;
        a2 = 29 * a2 + Objects.hashCode(this.goto);
        a2 = 29 * a2 + Arrays.hashCode(this.enum);
        a2 = 29 * a2 + Arrays.hashCode(this.const);
        a2 = 29 * a2 + this.catch;
        a2 = 29 * a2 + this.void;
        return a2;
    }

    public String toString() {
        return SparseMatrixUtils.toString(this);
    }

    @Override
    public CSRSparseMatrix deepCopy() {
        return new CSRSparseMatrix(this);
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.catch, this.void);
        for (CompressedRowPointers.Row a3 : this.goto.pointersForEachRow()) {
            for (int a4 = a3.class; a4 < a3.enum; ++a4) {
                a2.set(a3.goto, this.enum[a4], this.const[a4]);
            }
        }
        return a2;
    }

    public CSRSparseMatrix(int nRows, int nCols) {
        this.else = 0;
        this.goto = null;
        this.enum = null;
        this.const = null;
        this.catch = nRows;
        this.void = nCols;
        this.else = 0;
        this.const = new double[0];
        this.enum = new int[0];
        this.goto = CompressedRowPointers.withRowCount(nRows);
    }

    private CSRSparseMatrix(int a2, int a3, SparseMatrix.Entry[] a4, boolean a5) {
        CSRSparseMatrix a6;
        a6.else = 0;
        a6.goto = null;
        a6.enum = null;
        a6.const = null;
        a6.catch = a2;
        a6.void = a3;
        a6.else = a4.length;
        if (!a5) {
            Arrays.parallelSort(a4, SparseMatrix.Entry.ROW_MAJOR_ORDER);
        }
        int[] a7 = new int[a6.else];
        a6.enum = new int[a6.else];
        a6.const = new double[a6.else];
        int a8 = -1;
        int a9 = -1;
        for (int a10 = 0; a10 < a4.length; ++a10) {
            int a11 = a4[a10].coordinates.i;
            int a12 = a4[a10].coordinates.j;
            if (a8 == a11 && a9 == a12) {
                throw new RepeatedCoordinatesException(a4[a10].coordinates);
            }
            a7[a10] = a11;
            a6.enum[a10] = a12;
            a6.const[a10] = a4[a10].value;
            a8 = a11;
            a9 = a12;
        }
        a6.goto = CompressedRowPointers.fromRowIndices(a2, a7, true);
    }

    @Override
    public SparseVector getRow(int i2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        int a2 = this.goto.get(i2 - 1);
        int a3 = this.goto.get(i2);
        SparseVector a4 = new SparseVector(this.void);
        for (int a5 = a2; a5 < a3; ++a5) {
            a4.set(this.enum[a5], this.const[a5]);
        }
        return a4;
    }

    @Override
    public SparseVector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        SparseVector a2 = new SparseVector(this.catch);
        block0: for (CompressedRowPointers.Row a3 : this.goto.pointersForEachRow()) {
            for (int a4 = a3.class; a4 < a3.enum; ++a4) {
                if (this.enum[a4] != j2) continue;
                a2.set(a3.goto, this.const[a4]);
                continue block0;
            }
        }
        return a2;
    }

    public CSRSparseMatrix(int nRows, int nCols, List<SparseMatrix.Entry> entryList, boolean areEntriesSorted) {
        this(nRows, nCols, entryList.toArray(new SparseMatrix.Entry[entryList.size()]), areEntriesSorted);
    }

    private CSRSparseMatrix do(CSRSparseMatrix a2) {
        int a3;
        CSRSparseMatrix a4;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a4, a2);
        int a6 = a2.void;
        Row[] a7 = new Row[a4.catch];
        IntStream.rangeClosed(1, a4.catch).parallel().forEach(a5 -> {
            CSRSparseMatrix a6;
            Scatter a7 = new Scatter(a6);
            for (int a8 = a6.goto.get(a5 - 1); a8 < a6.goto.get(a5); ++a8) {
                a7.do(a2, a6.enum[a8], a6.const[a8]);
            }
            a4[a5 - 1] = a7.do();
        });
        CSRSparseMatrix a8 = new CSRSparseMatrix(a4.catch, a2.void);
        int a9 = 0;
        int[] a10 = new int[a4.catch + 1];
        for (a3 = 0; a3 < a4.catch; ++a3) {
            a10[a3] = a9;
            a9 += a7[a3].enum;
        }
        a10[a4.catch] = a9;
        a8.else = a9;
        a8.const = new double[a9];
        a8.enum = new int[a9];
        int a11 = 0;
        for (a3 = 0; a3 < a4.catch; ++a3) {
            a11 += a7[a3].do(a8.enum, a8.const, a11);
        }
        a8.goto = CompressedRowPointers.fromRowPointers(a10);
        return a8;
    }

    private CSRSparseMatrix do(CSRSparseMatrix a2, double a3) {
        int a4;
        CSRSparseMatrix a6;
        DimensionCheck.throwIfDifferentDimension(a6, a2);
        Row[] a7 = new Row[a6.catch];
        IntStream.rangeClosed(1, a6.catch).parallel().forEach(a5 -> {
            CSRSparseMatrix a6;
            Scatter a7 = new Scatter(a6.void);
            a7.do(a6, a5, 1.0);
            a7.do(a2, a5, a3);
            a4[a5 - 1] = a7.do();
        });
        CSRSparseMatrix a8 = new CSRSparseMatrix(a6.catch, a6.void);
        int[] a9 = new int[a6.catch + 1];
        int a10 = 0;
        for (a4 = 0; a4 < a6.catch; ++a4) {
            a9[a4] = a10;
            a10 += a7[a4].enum;
        }
        a9[a6.catch] = a10;
        a8.else = a10;
        a8.const = new double[a10];
        a8.enum = new int[a10];
        for (a4 = 0; a4 < a6.catch; ++a4) {
            a7[a4].do(a8.enum, a8.const, a9[a4]);
        }
        a8.goto = CompressedRowPointers.fromRowPointers(a9);
        return a8;
    }

    @Override
    public int nCols() {
        return this.void;
    }

    @Override
    public List<SparseMatrix.Entry> getEntryList() {
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (CompressedRowPointers.Row a3 : this.goto.pointersForEachRow()) {
            for (int a4 = a3.class; a4 < a3.enum; ++a4) {
                a2.add(new SparseMatrix.Entry(new MatrixCoordinate(a3.goto, this.enum[a4]), this.const[a4]));
            }
        }
        return a2;
    }

    @Override
    public int nRows() {
        return this.catch;
    }

    private void do(int[] a2) {
        CSRSparseMatrix a4;
        if (a4.else == 0) {
            return;
        }
        IntStream.rangeClosed(1, a4.catch).parallel().forEach(a3 -> {
            CSRSparseMatrix a4;
            int a5 = a2[a3 - 1];
            int a6 = a2[a3];
            if (a5 == a6) {
                return;
            }
            CSRSparseMatrix.do(a4.enum, a4.const, a5, a6);
        });
    }

    public CSRSparseMatrix(CSRSparseMatrix that) {
        this.else = 0;
        this.goto = null;
        this.enum = null;
        this.const = null;
        this.catch = that.nRows();
        this.void = that.nCols();
        this.else = that.else;
        this.const = (double[])that.const.clone();
        this.enum = (int[])that.enum.clone();
        this.goto = CompressedRowPointers.copy(that.goto);
    }

    private static List<SparseMatrix.Entry> do(Matrix a2) {
        ArgumentAssertion.assertNotNull(a2, "A");
        if (a2 instanceof SparseMatrix) {
            return ((SparseMatrix)a2).getEntryList();
        }
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 1; a4 <= a2.nRows(); ++a4) {
            for (int a5 = 1; a5 <= a2.nCols(); ++a5) {
                double a6 = a2.get(a4, a5);
                if (a6 == 0.0) continue;
                a3.add(new SparseMatrix.Entry(new MatrixCoordinate(a4, a5), a6));
            }
        }
        return a3;
    }

    private CSRSparseMatrix do(SparseMatrix a2) {
        CSRSparseMatrix a3;
        return a3.do(new CSRSparseMatrix(a2.nRows(), a2.nCols(), a2.getEntryList()));
    }

    @Override
    public SparseMatrix.ValueArray getValueArray() {
        int a2 = this.nNonZeros();
        int[] a3 = new int[a2];
        int[] a4 = (int[])this.enum.clone();
        double[] a5 = (double[])this.const.clone();
        for (CompressedRowPointers.Row a6 : this.goto.pointersForEachRow()) {
            if (a6.class == a6.enum) continue;
            Arrays.fill(a3, a6.class, a6.enum, a6.goto);
        }
        return new SparseMatrix.ValueArray(a3, a4, a5);
    }

    @Override
    public double get(int i2, int j2) {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        int a2 = this.goto.get(i2 - 1);
        int a3 = this.goto.get(i2);
        int a4 = 0;
        for (a4 = a2; a4 < a3 && this.enum[a4] != j2; ++a4) {
        }
        return a4 == a3 ? 0.0 : this.const[a4];
    }

    @Override
    public SparseMatrix subMatrix(int rowFrom, int rowTo, int colFrom, int colTo) {
        ArgumentAssertion.assertGreaterThan(rowFrom, 0, "rowFrom");
        ArgumentAssertion.assertGreaterThan(colFrom, 0, "colFrom");
        ArgumentAssertion.assertNotGreaterThan(rowTo, this.catch, "rowTo");
        ArgumentAssertion.assertNotGreaterThan(colTo, this.void, "colTo");
        ArgumentAssertion.assertTrue(rowFrom <= rowTo, "rowFrom <= rowTo", new Object[0]);
        ArgumentAssertion.assertTrue(colFrom <= colTo, "colfrom <= colTo", new Object[0]);
        ArrayList<SparseMatrix.Entry> a2 = new ArrayList<SparseMatrix.Entry>(this.nNonZeros());
        for (CompressedRowPointers.Row a3 : this.goto.pointersForEachRow()) {
            if (a3.goto < rowFrom || a3.goto > rowTo) continue;
            for (int a4 = a3.class; a4 < a3.enum; ++a4) {
                if (this.enum[a4] < colFrom || this.enum[a4] > colTo) continue;
                a2.add(new SparseMatrix.Entry(new MatrixCoordinate(a3.goto - rowFrom + 1, this.enum[a4] - colFrom + 1), this.const[a4]));
            }
        }
        return new CSRSparseMatrix(rowTo - rowFrom + 1, colTo - colFrom + 1, a2, true);
    }

    private CSRSparseMatrix do() {
        CSRSparseMatrix a2;
        CSRSparseMatrix a3 = new CSRSparseMatrix(a2.void, a2.catch);
        double[] a4 = new double[a2.const.length];
        int[] a5 = new int[a2.enum.length];
        int[] a6 = new int[a2.void + 1];
        for (int a7 = 0; a7 < a2.enum.length; ++a7) {
            int n = a2.enum[a7];
            a6[n] = a6[n] + 1;
        }
        a6 = DoubleUtils.cumsum(a6);
        a3.goto = CompressedRowPointers.fromRowPointers((int[])a6.clone());
        for (CompressedRowPointers.Row a8 : a2.goto.pointersForEachRow()) {
            for (int a9 = a8.class; a9 < a8.enum; ++a9) {
                int n = a2.enum[a9] - 1;
                a6[n] = a6[n] + 1;
                a5[a] = a8.goto;
                a4[a] = a2.const[a9];
            }
        }
        a3.const = a4;
        a3.enum = a5;
        a3.else = a2.else;
        return a3;
    }

    @Override
    public void set(int row, int col, double value) {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        int[] a2 = this.goto.uncompress();
        int a3 = a2[row - 1];
        int a4 = a2[row];
        int a5 = 0;
        for (a5 = a3; a5 < a4 && this.enum[a5] < col; ++a5) {
        }
        if (a5 != a4 && this.enum[a5] == col) {
            if (value != 0.0) {
                this.const[a5] = value;
            } else {
                double[] a6 = this.const;
                this.const = new double[a6.length - 1];
                System.arraycopy(a6, 0, this.const, 0, a5);
                System.arraycopy(a6, a5 + 1, this.const, a5, this.const.length - a5);
                int[] a7 = this.enum;
                this.enum = new int[a7.length - 1];
                System.arraycopy(a7, 0, this.enum, 0, a5);
                System.arraycopy(a7, a5 + 1, this.enum, a5, this.enum.length - a5);
                int a8 = row;
                while (a8 < a2.length) {
                    int n = a8++;
                    a2[n] = a2[n] - 1;
                }
                --this.else;
            }
        } else {
            if (value == 0.0) {
                return;
            }
            double[] a9 = this.const;
            this.const = new double[a9.length + 1];
            System.arraycopy(a9, 0, this.const, 0, a5);
            System.arraycopy(a9, a5, this.const, a5 + 1, a9.length - a5);
            this.const[a5] = value;
            int[] a10 = this.enum;
            this.enum = new int[a10.length + 1];
            System.arraycopy(a10, 0, this.enum, 0, a5);
            System.arraycopy(a10, a5, this.enum, a5 + 1, a10.length - a5);
            this.enum[a5] = col;
            int a11 = row;
            while (a11 < a2.length) {
                int n = a11++;
                a2[n] = a2[n] + 1;
            }
            ++this.else;
        }
        this.goto = CompressedRowPointers.fromRowPointers(a2);
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        if (v instanceof SparseVector) {
            return ((SparseVector)v).leftMultiply(this);
        }
        double[] a2 = new double[this.catch];
        IntStream.rangeClosed(1, this.catch).parallel().forEach(a4 -> {
            CSRSparseMatrix a5;
            a2[a4 - 1] = a5.getRow(a4).innerProduct(v);
        });
        Vector a3 = v instanceof SparseVector ? new SparseVector(a2) : new DenseVector(a2);
        return a3;
    }

    @Override
    public CSRSparseMatrix ZERO() {
        return new CSRSparseMatrix(this.catch, this.void);
    }

    private static void do(int[] a2, double[] a3, int a4, int a5) {
        Object[] a6 = new IndexedValue[a5 - a4];
        int a7 = a4;
        int a8 = 0;
        while (a7 < a5) {
            a6[a8] = new IndexedValue(a2[a7], a3[a7]);
            ++a7;
            ++a8;
        }
        Arrays.sort(a6);
        a7 = a4;
        a8 = 0;
        while (a7 < a5) {
            a2[a7] = ((IndexedValue)a6[a8]).goto;
            a3[a7] = ((IndexedValue)a6[a8]).enum;
            ++a7;
            ++a8;
        }
    }

    @Override
    public CSRSparseMatrix ONE() {
        int a2 = Math.min(this.catch, this.void);
        double[] a3 = DoubleUtils.rep(1.0, a2);
        int[] a4 = DoubleUtils.seq(1, a2);
        int[] a5 = DoubleUtils.seq(1, a2);
        return new CSRSparseMatrix(this.catch, this.void, a4, a5, a3);
    }

    @Override
    public CSRSparseMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public CSRSparseMatrix scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new CSRSparseMatrix(this.catch, this.void);
        }
        CSRSparseMatrix a2 = new CSRSparseMatrix(this);
        int a3 = 0;
        while (a3 < a2.const.length) {
            int n = a3++;
            a2.const[n] = a2.const[n] * c2;
        }
        return a2;
    }

    @Override
    public Matrix minus(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.do((CSRSparseMatrix)that, -1.0);
        }
        return CSRSparseMatrix.class.minus(this, that);
    }

    @Override
    public Matrix multiply(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.do((CSRSparseMatrix)that);
        }
        if (that instanceof SparseMatrix) {
            return this.do((SparseMatrix)that);
        }
        return this.do(that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SparseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        CSRSparseMatrix a2 = (CSRSparseMatrix)obj;
        if (this.catch != a2.catch) {
            return false;
        }
        if (this.void != a2.void) {
            return false;
        }
        return SparseMatrixUtils.equals(this, a2);
    }

    public CSRSparseMatrix(Matrix A2) {
        this(A2.nRows(), A2.nCols(), CSRSparseMatrix.do(A2));
    }

    private static int do(int[] a2, double[] a3) {
        int a4 = 0;
        for (int a5 = 0; a5 < a3.length; ++a5) {
            if (Double.compare(0.0, a3[a5]) == 0) continue;
            if (a4 != a5) {
                a3[a4] = a3[a5];
                a2[a4] = a2[a5];
            }
            ++a4;
        }
        return a4;
    }

    @Override
    public Matrix add(Matrix that) {
        if (that instanceof CSRSparseMatrix) {
            return this.do((CSRSparseMatrix)that, 1.0);
        }
        return CSRSparseMatrix.class.add(this, that);
    }

    @Override
    public CSRSparseMatrix t() {
        return this.do();
    }

    @Override
    public int nNonZeros() {
        return this.else;
    }

    private Matrix do(Matrix a2) {
        CSRSparseMatrix a3;
        DimensionCheck.throwIfIncompatible4Multiplication((Table)a3, a2);
        int a4 = a3.nRows();
        int a6 = a2.nCols();
        double[][] a7 = new double[a4][a6];
        IntStream.rangeClosed(1, a4).parallel().forEach(a5 -> {
            CSRSparseMatrix a6;
            for (int a7 = a6.goto.get(a5 - 1); a7 < a6.goto.get(a5); ++a7) {
                int a8 = a6.enum[a7];
                double a9 = a6.const[a7];
                for (int a10 = 1; a10 <= a6; ++a10) {
                    double[] dArray = a7[a5 - 1];
                    int n = a10 - 1;
                    dArray[n] = dArray[n] + a9 * a2.get(a8, a10);
                }
            }
        });
        return new DenseMatrix(a7);
    }

    private void do() {
        CSRSparseMatrix a2;
        a2.do(new CheckForKeptValue(){

            @Override
            public boolean toKeep(double value) {
                return Double.compare(0.0, value) != 0;
            }
            {
                1 a3;
            }
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class CompressedRowPointers {
        private final int[] class;
        private final int goto;
        private final int[] enum;

        public int[] uncompress() {
            int a2;
            int[] a3 = new int[this.goto + 1];
            for (a2 = 0; a2 < this.class.length - 1; ++a2) {
                for (int a4 = this.class[a2]; a4 < this.class[a2 + 1]; ++a4) {
                    a3[a4] = this.enum[a2];
                }
            }
            for (a2 = this.class[this.class.length - 1]; a2 < a3.length; ++a2) {
                a3[a2] = this.enum[this.class.length - 1];
            }
            return a3;
        }

        public Iterable<Row> pointersForEachRow() {
            return () -> {
                CompressedRowPointers a2;
                return new Iterator<Row>(){
                    private int goto = 0;
                    private int enum = 0;

                    @Override
                    public boolean hasNext() {
                        return this.enum < a2.goto;
                    }
                    {
                        1 a3;
                    }

                    @Override
                    public Row next() {
                        int a22;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException(String.format("row = %d; #rows = %d", this.enum + 1, a2.goto));
                        }
                        int a3 = this.enum + 1;
                        int a4 = a2.enum[this.goto];
                        ++this.enum;
                        if (this.goto == a2.class.length - 1 || this.enum < a2.class[this.goto + 1]) {
                            a22 = a2.enum[this.goto];
                        } else {
                            ++this.goto;
                            a22 = a2.enum[this.goto];
                        }
                        return new Row(a3, a4, a22);
                    }
                };
            };
        }

        public int hashCode() {
            int a2 = 5;
            a2 = 23 * a2 + this.goto;
            a2 = 23 * a2 + Arrays.hashCode(this.class);
            a2 = 23 * a2 + Arrays.hashCode(this.enum);
            return a2;
        }

        public int get(int row) {
            int a2 = Arrays.binarySearch(this.class, row);
            if (a2 >= 0) {
                return this.enum[a2];
            }
            return this.enum[-a2 - 2];
        }

        private CompressedRowPointers(int a2, int[] a3, int[] a4) {
            CompressedRowPointers a5;
            a5.goto = a2;
            a5.class = a3;
            a5.enum = a4;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompressedRowPointers a2 = (CompressedRowPointers)obj;
            if (this.goto != a2.goto) {
                return false;
            }
            if (!Arrays.equals(this.class, a2.class)) {
                return false;
            }
            return Arrays.equals(this.enum, a2.enum);
        }

        public static CompressedRowPointers fromRowIndices(int nRows, int[] rowIndices, boolean isSorted) {
            if (rowIndices.length == 0) {
                return CompressedRowPointers.withRowCount(nRows);
            }
            int[] a2 = rowIndices;
            if (!isSorted) {
                a2 = (int[])rowIndices.clone();
                Arrays.sort(a2);
            }
            int a3 = 0;
            int a4 = -1;
            for (int a5 = 0; a5 < a2.length; ++a5) {
                if (a4 == a2[a5]) continue;
                ++a3;
                a4 = a2[a5];
            }
            int[] a6 = new int[a3 + 1];
            int[] a22 = new int[a3 + 1];
            int a7 = 0;
            int a8 = a2[0];
            for (int a9 = 0; a9 < a2.length; ++a9) {
                if (a8 == a2[a9]) continue;
                a6[++a7] = a8;
                a22[a7] = a9;
                a8 = a2[a9];
            }
            a6[a3] = a8;
            a22[a3] = a2.length;
            return new CompressedRowPointers(nRows, a6, a22);
        }

        public int nRows() {
            return this.goto;
        }

        public static CompressedRowPointers copy(CompressedRowPointers that) {
            return new CompressedRowPointers(that.goto, (int[])that.class.clone(), (int[])that.enum.clone());
        }

        public static CompressedRowPointers fromRowPointers(int[] rowPointers) {
            int a2 = rowPointers.length - 1;
            int a3 = 0;
            int a4 = -1;
            for (int a5 = 0; a5 < rowPointers.length; ++a5) {
                if (a4 == rowPointers[a5]) continue;
                ++a3;
                a4 = rowPointers[a5];
            }
            int[] a6 = new int[a3];
            int[] a22 = new int[a3];
            int a7 = 0;
            int a8 = -1;
            for (int a9 = 0; a9 < rowPointers.length; ++a9) {
                if (a8 == rowPointers[a9]) continue;
                a6[a7] = a9;
                a22[a7] = rowPointers[a9];
                ++a7;
                a8 = rowPointers[a9];
            }
            return new CompressedRowPointers(a2, a6, a22);
        }

        public static CompressedRowPointers withRowCount(int nRows) {
            return new CompressedRowPointers(nRows, new int[]{0}, new int[]{0});
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private static class Row {
            private final int class;
            private final int goto;
            private final int enum;

            private Row(int a2, int a3, int a4) {
                Row a5;
                a5.goto = a2;
                a5.class = a3;
                a5.enum = a4;
            }
        }
    }

    private static interface CheckForKeptValue {
        public boolean toKeep(double var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Row {
        private final double[] class;
        private final int[] goto;
        private final int enum;

        private int do(int[] a2, double[] a3, int a4) {
            Row a5;
            System.arraycopy(a5.goto, 0, a2, a4, a5.enum);
            System.arraycopy(a5.class, 0, a3, a4, a5.enum);
            return a5.enum;
        }

        private Row(int[] a2, double[] a3, int a4) {
            Row a5;
            a5.goto = a2;
            a5.class = a3;
            a5.enum = a4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Scatter {
        private final int[] void;
        private final boolean[] class;
        private final double[] goto;
        private int enum;

        private void do(CSRSparseMatrix a2, int a3, double a4) {
            int a5 = a2.goto.get(a3 - 1);
            int a6 = a2.goto.get(a3);
            for (int a7 = a5; a7 < a6; ++a7) {
                Scatter a8;
                int a9 = a2.enum[a7];
                if (!a8.class[a9]) {
                    a8.class[a9] = true;
                    a8.void[a8.enum++] = a9;
                }
                int n = a9;
                a8.goto[n] = a8.goto[n] + a4 * a2.const[a7];
            }
        }

        private Row do() {
            int a2;
            Scatter a3;
            int[] a4 = Arrays.copyOf(a3.void, a3.enum);
            double[] a5 = new double[a3.enum];
            for (a2 = 0; a2 < a3.enum; ++a2) {
                a5[a2] = a3.goto[a3.void[a2]];
            }
            a2 = CSRSparseMatrix.do(a4, a5);
            if (a3.enum != a2) {
                a4 = Arrays.copyOf(a4, a2);
                a5 = Arrays.copyOf(a5, a2);
            }
            CSRSparseMatrix.do(a4, a5, 0, a2);
            return new Row(a4, a5, a2);
        }

        private Scatter(int a2) {
            Scatter a3;
            a3.class = new boolean[a2 + 1];
            a3.goto = new double[a2 + 1];
            a3.void = new int[a2];
            a3.enum = 0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class IndexedValue
    implements Comparable<IndexedValue> {
        private final int goto;
        private final double enum;

        private IndexedValue(int a2, double a3) {
            IndexedValue a4;
            a4.goto = a2;
            a4.enum = a3;
        }

        @Override
        public int compareTo(IndexedValue o) {
            return this.goto - o.goto;
        }
    }
}

