/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DiagonalMatrix
extends DiagonalDataMatrix {
    private final int goto;
    private final int enum;

    public DiagonalMatrix(int nRows, int nCols) {
        this(new DiagonalData(DiagonalData.Type.DIAGONAL, Math.min(nRows, nCols)), nRows, nCols);
    }

    @Override
    public DiagonalMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public int nRows() {
        return this.enum;
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DiagonalMatrix) {
            DiagonalData a2 = this.storage.add(((DiagonalMatrix)that).storage);
            DiagonalMatrix a3 = new DiagonalMatrix(a2, this.enum, this.goto);
            return a3;
        }
        return super.add(that);
    }

    public DiagonalMatrix(double[] data, int nRows, int nCols) {
        this(new DiagonalData(new double[][]{data}), nRows, nCols);
    }

    @Override
    public Vector multiply(Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        DenseVector a2 = new DenseVector(this.storage.getDiagonal());
        return v.multiply(a2);
    }

    @Override
    public int nCols() {
        return this.goto;
    }

    @Override
    public DiagonalMatrix ZERO() {
        return new DiagonalMatrix(this.storage.dim);
    }

    @Override
    public DiagonalMatrix t() {
        return new DiagonalMatrix(this.storage, this.goto, this.enum);
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DiagonalMatrix) {
            DiagonalData a2 = this.storage.minus(((DiagonalMatrix)that).storage);
            DiagonalMatrix a3 = new DiagonalMatrix(a2, this.enum, this.goto);
            return a3;
        }
        return super.minus(that);
    }

    @Override
    public DiagonalMatrix scaled(double scalar) {
        DiagonalData a2 = this.storage.scaled(scalar);
        DiagonalMatrix a3 = new DiagonalMatrix(a2, this.enum, this.goto);
        return a3;
    }

    @Override
    public DiagonalMatrix deepCopy() {
        return new DiagonalMatrix(this);
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        if (that instanceof DiagonalMatrix) {
            double[] a2 = this.storage.getDiagonal();
            double[] a3 = ((DiagonalMatrix)that).storage.getDiagonal();
            double[] a4 = new double[this.storage.dim];
            for (int a5 = 0; a5 < this.storage.dim; ++a5) {
                a4[a5] = a2[a5] * a3[a5];
            }
            return new DiagonalMatrix(a4);
        }
        DenseMatrix a6 = new DenseMatrix(this.nRows(), that.nCols());
        for (int a7 = 1; a7 <= a6.nRows(); ++a7) {
            for (int a8 = 1; a8 <= a6.nCols(); ++a8) {
                a6.set(a7, a8, this.get(a7, a7) * that.get(a7, a8));
            }
        }
        return a6;
    }

    @Override
    public String toString() {
        return MatrixUtils.toString(this);
    }

    private DiagonalMatrix(DiagonalData a2, int a3, int a4) {
        super(a2);
        DiagonalMatrix a5;
        a5.enum = a3;
        a5.goto = a4;
    }

    public DiagonalMatrix(double[] data) {
        this(new DiagonalData(new double[][]{data}), data.length, data.length);
    }

    @Override
    public DiagonalMatrix ONE() {
        double[] a2 = DoubleUtils.rep(1.0, this.storage.dim);
        DiagonalMatrix a3 = new DiagonalMatrix(a2);
        return a3;
    }

    public DiagonalMatrix(DiagonalMatrix that) {
        this(new DiagonalData(that.storage), that.enum, that.goto);
    }

    public DiagonalMatrix(int dim) {
        this(new DiagonalData(DiagonalData.Type.DIAGONAL, dim), dim, dim);
    }
}

