/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal;

import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class DiagonalData
implements MatrixAccess,
Densifiable {
    private double[][] enum;
    final int dim;
    final Type type;

    @Override
    public double get(int i2, int j2) {
        if (this.enum == null) {
            return 0.0;
        }
        if (i2 == j2 - 1) {
            return this.enum[0] != null ? this.enum[0][i2 - 1] : 0.0;
        }
        if (i2 == j2) {
            return this.enum[1] != null ? this.enum[1][i2 - 1] : 0.0;
        }
        if (i2 == j2 + 1) {
            return this.enum[2] != null ? this.enum[2][i2 - 2] : 0.0;
        }
        return 0.0;
    }

    @Override
    public int nRows() {
        return this.dim;
    }

    private void case(double[] a2) {
        DiagonalData a3;
        if (a2 != null) {
            ArgumentAssertion.assertTrue(a2.length == a3.dim, "data set is not diagonal", new Object[0]);
            a3.enum[1] = Arrays.copyOf(a2, a3.dim);
        } else {
            a3.enum[1] = new double[a3.dim];
        }
    }

    DiagonalData opposite() {
        DiagonalData a2;
        return a2.scaled(-1.0);
    }

    @Override
    public int nCols() {
        return this.dim;
    }

    private void do(DiagonalData a2, DiagonalData a3) {
        if (a2.type != a3.type) {
            throw new IllegalArgumentException("the two data set are not of the same type");
        }
    }

    private void short(double[] a2) {
        DiagonalData a3;
        if (a2 != null) {
            ArgumentAssertion.assertTrue(a2.length == a3.dim - 1, "data set is not super-diagonal", new Object[0]);
            a3.enum[0] = Arrays.copyOf(a2, a3.dim - 1);
        } else {
            a3.enum[0] = new double[a3.dim - 1];
        }
    }

    double[] getDiagonal() {
        DiagonalData a2;
        double[] a3 = Arrays.copyOf(a2.enum[1], a2.enum[1].length);
        return a3;
    }

    DiagonalData minus(DiagonalData a2) {
        DiagonalData a3;
        a3.do(a3, a2);
        DiagonalData a4 = new DiagonalData(a3.type, a3.dim);
        for (int a5 = 0; a5 <= 2; ++a5) {
            if (a3.enum[a5] == null) continue;
            int a6 = a3.enum[a5].length;
            a4.enum[a5] = new double[a6];
            for (int a7 = 0; a7 < a6; ++a7) {
                a4.enum[a5][a7] = a3.enum[a5][a7] - a2.enum[a5][a7];
            }
        }
        return a4;
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 47 * a2 + this.dim;
        a2 = 47 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        a2 = 47 * a2 + (this.type != null ? this.type.hashCode() : 0);
        return a2;
    }

    double[] getSuperDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.enum[0] != null ? Arrays.copyOf(a2.enum[0], a2.enum[0].length) : new double[a2.dim - 1];
        return a3;
    }

    DiagonalData scaled(double a2) {
        DiagonalData a3;
        DiagonalData a4 = new DiagonalData(a3.type, a3.dim);
        for (int a5 = 0; a5 <= 2; ++a5) {
            if (a3.enum[a5] == null) continue;
            int a6 = a3.enum[a5].length;
            a4.enum[a5] = new double[a6];
            for (int a7 = 0; a7 < a6; ++a7) {
                a4.enum[a5][a7] = a3.enum[a5][a7] * a2;
            }
        }
        return a4;
    }

    double[] getSubDiagonal() {
        DiagonalData a2;
        double[] a3 = a2.enum[2] != null ? Arrays.copyOf(a2.enum[2], a2.enum[2].length) : new double[a2.dim - 1];
        return a3;
    }

    DiagonalData(double[][] a2) {
        DiagonalData a3;
        a3.enum = null;
        a3.enum = new double[3][];
        switch (a2.length) {
            case 1: {
                a3.type = Type.DIAGONAL;
                a3.dim = a2[0].length;
                a3.case(a2[0]);
                break;
            }
            case 2: {
                if (a2[0].length > a2[1].length) {
                    a3.type = Type.BI_DIAGONAL_LOWER;
                    a3.dim = a2[0].length;
                    a3.case(a2[0]);
                    a3.do(a2[1]);
                    break;
                }
                a3.type = Type.BI_DIAGONAL_UPPER;
                a3.dim = a2[1].length;
                a3.short(a2[0]);
                a3.case(a2[1]);
                break;
            }
            case 3: {
                a3.type = Type.TRI_DIAGONAL;
                a3.dim = a2[1].length;
                a3.short(a2[0]);
                a3.case(a2[1]);
                a3.do(a2[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid data set");
            }
        }
    }

    DiagonalData(DiagonalData a2) {
        DiagonalData a3;
        a3.enum = null;
        a3.dim = a2.dim;
        a3.type = a2.type;
        (a3.enum = (double[][])new double[3][])[0] = a2.enum[0] != null ? (double[])a2.enum[0].clone() : null;
        a3.enum[1] = a2.enum[1] != null ? (double[])a2.enum[1].clone() : null;
        a3.enum[2] = a2.enum[2] != null ? (double[])a2.enum[2].clone() : null;
    }

    DiagonalData(Type a2, int a3) {
        DiagonalData a4;
        a4.enum = null;
        a4.dim = a3;
        a4.type = a2;
        a4.enum = new double[3][];
        switch (a2) {
            case TRI_DIAGONAL: {
                a4.enum[0] = new double[a3 - 1];
                a4.enum[1] = new double[a3];
                a4.enum[2] = new double[a3 - 1];
                break;
            }
            case BI_DIAGONAL_UPPER: {
                a4.enum[0] = new double[a3 - 1];
                a4.enum[1] = new double[a3];
                break;
            }
            case BI_DIAGONAL_LOWER: {
                a4.enum[1] = new double[a3];
                a4.enum[2] = new double[a3 - 1];
                break;
            }
            case DIAGONAL: {
                a4.enum[1] = new double[a3];
            }
        }
    }

    private void do(double[] a2) {
        DiagonalData a3;
        if (a2 != null) {
            ArgumentAssertion.assertTrue(a2.length == a3.dim - 1, "data set is not sub-diagonal", new Object[0]);
            a3.enum[2] = Arrays.copyOf(a2, a3.dim - 1);
        } else {
            a3.enum[2] = new double[a3.dim - 1];
        }
    }

    DiagonalData add(DiagonalData a2) {
        DiagonalData a3;
        a3.do(a3, a2);
        DiagonalData a4 = new DiagonalData(a3.type, a3.dim);
        for (int a5 = 0; a5 <= 2; ++a5) {
            if (a3.enum[a5] == null) continue;
            int a6 = a3.enum[a5].length;
            a4.enum[a5] = new double[a6];
            for (int a7 = 0; a7 < a6; ++a7) {
                a4.enum[a5][a7] = a3.enum[a5][a7] + a2.enum[a5][a7];
            }
        }
        return a4;
    }

    public String toString() {
        return this.toDense().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagonalData a2 = (DiagonalData)obj;
        if (this.dim != a2.dim) {
            return false;
        }
        if (this.enum != a2.enum) {
            for (int a3 = 0; a3 < 3; ++a3) {
                if (!(this.enum[a3] != null && a2.enum[a3] != null ? !DoubleUtils.equal(this.enum[a3], a2.enum[a3], 0.0) : (this.enum[a3] == null ? a2.enum[a3] != null && !DoubleUtils.isAllZeros(a2.enum[a3], 0.0) : a2.enum[a3] == null && !DoubleUtils.isAllZeros(this.enum[a3], 0.0)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = new DenseMatrix(this.dim, this.dim);
        a2.set(1, 1, this.get(1, 1));
        if (this.dim >= 2) {
            a2.set(1, 2, this.get(1, 2));
            for (int a3 = 2; a3 < this.dim; ++a3) {
                a2.set(a3, a3 - 1, this.get(a3, a3 - 1));
                a2.set(a3, a3, this.get(a3, a3));
                a2.set(a3, a3 + 1, this.get(a3, a3 + 1));
            }
            a2.set(this.dim, this.dim, this.get(this.dim, this.dim));
            a2.set(this.dim, this.dim - 1, this.get(this.dim, this.dim - 1));
        }
        return a2;
    }

    @Override
    public void set(int i2, int j2, double value) {
        if (i2 == j2 - 1 && this.enum[0] != null) {
            this.enum[0][i2 - 1] = value;
        } else if (i2 == j2) {
            this.enum[1][i2 - 1] = value;
        } else if (i2 == j2 + 1 && this.enum[2] != null) {
            this.enum[2][i2 - 2] = value;
        } else if (!DoubleUtils.isZero(value, 0.0)) {
            throw new IllegalArgumentException(String.format("U[%d][%d] is always 0", i2, j2));
        }
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static enum Type {
        TRI_DIAGONAL,
        BI_DIAGONAL_UPPER,
        BI_DIAGONAL_LOWER,
        DIAGONAL;


        private Type() {
            Type a2;
        }
    }
}

