/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.RowMajorDenseData;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.multiplication.DenseMatrixMultiplicationByBlock;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.MultipleExecutionException;
import dev.nm.misc.parallel.ParallelExecutor;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DenseMatrix
implements Matrix,
Densifiable {
    private static final int class = 10000;
    private static final MatrixMathOperation goto = new AutoParallelMatrixMathOperation();
    private final RowMajorDenseData enum;

    public DenseMatrix(Vector v) {
        this(v.toArray(), v.size(), 1);
    }

    @Override
    public Matrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public DenseMatrix ONE() {
        int a2 = this.nCols();
        int a3 = 0;
        double[] a4 = new double[this.nRows() * a2];
        for (int a5 = 0; a5 < a4.length && a3 < a2; ++a3, a5 += a2) {
            a4[a5 + a3] = 1.0;
        }
        DenseMatrix a6 = new DenseMatrix(a4, this.nRows(), a2);
        return a6;
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DenseMatrix) {
            return new DenseMatrix((RowMajorDenseData)this.enum.minus(((DenseMatrix)that).enum));
        }
        return goto.minus(this, that);
    }

    public Vector getColumn(int j2, int beginRow, int endRow) {
        int a2 = this.nRows();
        int a3 = this.nCols();
        ArgumentAssertion.assertRange(j2, 1, a3, "j");
        ArgumentAssertion.assertRange(beginRow, 1, a2, "beginRow");
        ArgumentAssertion.assertRange(endRow, 1, a2, "endRow");
        double[] a4 = this.enum.asArray();
        double[] a5 = new double[endRow - beginRow + 1];
        int a6 = 0;
        int a7 = j2 - 1 + (beginRow - 1) * a3;
        while (a6 <= endRow - beginRow) {
            a5[a6] = a4[a7];
            ++a6;
            a7 += a3;
        }
        return new DenseVector(a5);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!DenseMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        DenseMatrix a2 = (DenseMatrix)obj;
        return this.enum == a2.enum || this.enum != null && this.enum.equals(a2.enum);
    }

    public Vector getRow(int i2, int beginCol, int endCol) {
        int a2 = this.nCols();
        ArgumentAssertion.assertRange(i2, 1, this.nRows(), "i");
        ArgumentAssertion.assertRange(beginCol, 1, a2, "beginCol");
        ArgumentAssertion.assertRange(endCol, 1, a2, "endCol");
        int a3 = a2 * (i2 - 1);
        double[] a4 = Arrays.copyOfRange(this.enum.asArray(), a3 + beginCol - 1, a3 + endCol);
        return new DenseVector(a4);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public DenseMatrix(double[][] data) {
        this(RowMajorDenseData.convertFrom2dArray(data), data.length, data[0].length);
    }

    public DenseMatrix(int nRows, int nCols) {
        this.enum = new RowMajorDenseData(nRows, nCols);
    }

    @Override
    public DenseMatrix toDense() {
        return new DenseMatrix(this);
    }

    public DenseMatrix(DenseMatrix A2) {
        this((RowMajorDenseData)A2.enum.deepCopy());
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 41 * a2 + (this.enum != null ? this.enum.hashCode() : 0);
        return a2;
    }

    @Override
    public Vector multiply(final Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, v);
        if (v instanceof SparseVector) {
            return ((SparseVector)v).leftMultiply(this);
        }
        final int a2 = this.nCols();
        final double[] a3 = this.enum.asArray();
        final double[] a4 = new double[this.nRows()];
        try {
            ParallelExecutorInstanceHolder.enum.conditionalForLoop(a4.length >= 10000, 0, a4.length, 1, new LoopBody(){
                {
                    2 a32;
                }

                @Override
                public void run(int i2) throws Exception {
                    double a22 = 0.0;
                    for (int a32 = 0; a32 < v.size(); ++a32) {
                        a22 += a3[i2 * a2 + a32] * v.get(a32 + 1);
                    }
                    a4[i2] = a22;
                }
            });
        }
        catch (MultipleExecutionException a5) {
            throw new RuntimeException(a5);
        }
        DenseVector a6 = new DenseVector(a4);
        return a6;
    }

    @Override
    public Vector getRow(int i2) {
        return this.getRow(i2, 1, this.nCols());
    }

    @Override
    public int nCols() {
        return this.enum.nCols();
    }

    public DenseMatrix(double[] data, int nRows, int nCols) {
        ArgumentAssertion.assertTrue(data.length == nRows * nCols, "the data length does not match the matrix dimension", new Object[0]);
        this.enum = new RowMajorDenseData(data, nRows, nCols);
    }

    @Override
    public DenseMatrix t() {
        final int a2 = this.nRows();
        final int a3 = this.nCols();
        final double[] a4 = this.enum.asArray();
        final double[] a5 = new double[a4.length];
        try {
            ParallelExecutorInstanceHolder.enum.conditionalForLoop(a4.length >= 10000, 0, a3, new LoopBody(){

                @Override
                public void run(int i2) throws Exception {
                    int a22 = i2 * a2;
                    int a32 = a22 + a2;
                    int a42 = a22;
                    int a52 = i2;
                    while (a42 < a32) {
                        a5[a42] = a4[a52];
                        ++a42;
                        a52 += a3;
                    }
                }
                {
                    1 a32;
                }
            });
        }
        catch (MultipleExecutionException a6) {
            throw new RuntimeException(a6);
        }
        DenseMatrix a7 = new DenseMatrix(a5, a3, a2);
        return a7;
    }

    @Override
    public DenseMatrix ZERO() {
        return new DenseMatrix(this.nRows(), this.nCols());
    }

    public DenseMatrix(Matrix A2) {
        if (A2 instanceof DenseMatrix) {
            this.enum = (RowMajorDenseData)((DenseMatrix)A2).enum.deepCopy();
            return;
        }
        int a2 = A2.nRows();
        int a3 = A2.nCols();
        if (A2 instanceof Densifiable) {
            DenseMatrix a4 = ((Densifiable)((Object)A2)).toDense();
            double[] a5 = a4.enum.asArray();
            this.enum = new RowMajorDenseData(a5, a2, a3);
            return;
        }
        double[] a6 = new double[A2.nRows() * A2.nCols()];
        int a7 = 0;
        for (int a8 = 1; a8 <= a2; ++a8) {
            for (int a9 = 1; a9 <= a3; ++a9) {
                a6[a7++] = A2.get(a8, a9);
            }
        }
        this.enum = new RowMajorDenseData(a6, a2, a3);
    }

    protected DenseMatrix(DenseMatrix A2, boolean copy) {
        this.enum = copy ? A2.enum.deepCopy() : A2.enum;
    }

    @Override
    public Vector getColumn(int j2) {
        return this.getColumn(j2, 1, this.nRows());
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        if (!(that instanceof DenseMatrix)) {
            return goto.multiply((MatrixAccess)this, that);
        }
        DenseMatrix a2 = ((DenseMatrix)that).t();
        double[] a3 = this.enum.asArray();
        double[] a4 = a2.enum.asArray();
        double[] a5 = new double[this.nRows() * that.nCols()];
        new DenseMatrixMultiplicationByBlock().multiply(a3, a4, a5, this.nRows(), this.nCols(), that.nCols());
        DenseMatrix a6 = new DenseMatrix(a5, this.nRows(), that.nCols());
        return a6;
    }

    @Override
    public DenseMatrix deepCopy() {
        return new DenseMatrix(this);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        return this.enum.get(i2, j2);
    }

    private DenseMatrix(RowMajorDenseData a2) {
        DenseMatrix a3;
        a3.enum = a2;
    }

    @Override
    public int nRows() {
        return this.enum.nRows();
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof DenseMatrix) {
            return new DenseMatrix((RowMajorDenseData)this.enum.add(((DenseMatrix)that).enum));
        }
        return goto.add(this, that);
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        this.enum.set(i2, j2, value);
    }

    public void setRow(int i2, Vector v) {
        ArgumentAssertion.assertTrue(v.size() == this.nCols(), "vector v has the wrong dimension", new Object[0]);
        for (int a2 = 1; a2 <= this.nCols(); ++a2) {
            this.enum.set(i2, a2, v.get(a2));
        }
    }

    public void setColumn(int j2, Vector v) {
        ArgumentAssertion.assertTrue(v.size() == this.nRows(), "vector v has the wrong dimension", new Object[0]);
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            this.enum.set(a2, j2, v.get(a2));
        }
    }

    @Override
    public DenseMatrix scaled(double c2) {
        return new DenseMatrix((RowMajorDenseData)this.enum.scaled(c2));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ParallelExecutorInstanceHolder {
        private static final ParallelExecutor enum = new ParallelExecutor(DenseMatrix.class.getSimpleName());

        private ParallelExecutorInstanceHolder() {
            ParallelExecutorInstanceHolder a2;
        }
    }
}

