/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.QRDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.Householder4SubVector;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.Householder4ZeroGenerator;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderReflection;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HouseholderQR
implements QRDecomposition {
    private final int const;
    private final double void;
    private final HouseholderInPlace class;
    private final int goto;
    private final HouseholderInPlace.Householder[] enum;

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.goto);
    }

    public HouseholderQR(Matrix A2, double epsilon) {
        this.const = A2.nRows();
        this.goto = A2.nCols();
        ArgumentAssertion.assertTrue(this.const >= this.goto, "QR decomposition by Householder Reflection applies to matrix where the number of rows >= the number of columns", new Object[0]);
        this.void = epsilon;
        this.class = new HouseholderInPlace(A2, epsilon);
        int a2 = Math.min(this.goto, this.const - 1);
        ArrayList<HouseholderInPlace.Householder> a3 = new ArrayList<HouseholderInPlace.Householder>(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            HouseholderInPlace.Householder a5 = this.class.generateAndReflectColumns(a4, this.goto, a4, this.const);
            a3.add(a5);
        }
        this.enum = a3.toArray(new HouseholderInPlace.Householder[a2]);
    }

    @Override
    public Matrix tallR() {
        return this.class.getTransformedMatrix();
    }

    @Override
    public int rank() {
        int a2 = 0;
        for (int a3 = 1; a3 <= this.goto; ++a3) {
            if (DoubleUtils.isZero(this.class.get(a3, a3), this.void)) continue;
            ++a2;
        }
        return a2;
    }

    public HouseholderQR(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    @Override
    public Matrix squareQ() {
        return this.class.U().t();
    }

    @Override
    public Matrix Q() {
        HouseholderInPlace a2 = new HouseholderInPlace(this.const, this.goto);
        for (int a3 = this.enum.length - 1; a3 >= 0; --a3) {
            a2.reflect(this.enum[a3], a3 + 1, this.goto);
        }
        return a2.getTransformedMatrix();
    }

    public HouseholderReflection[] getHouseholderMatrices() {
        HouseholderReflection[] a2 = new HouseholderReflection[this.enum.length];
        for (int a3 = 0; a3 < this.enum.length; ++a3) {
            HouseholderContext a4 = HouseholderInPlace.Householder.toContext(this.enum[a3]);
            a2[a3] = DoubleUtils.isZero(a4.lambda, this.void) ? new Householder4ZeroGenerator(this.const) : new Householder4SubVector(this.const, a4);
        }
        return a2;
    }

    @Override
    public UpperTriangularMatrix R() {
        Matrix a2 = this.class.getTransformedMatrix();
        double[][] a3 = new double[this.goto][];
        for (int a4 = 1; a4 <= this.goto; ++a4) {
            double[] a5 = new double[this.goto - a4 + 1];
            int a6 = a4;
            int a7 = 0;
            while (a6 <= this.goto) {
                a5[a7] = a2.get(a4, a6);
                ++a6;
                ++a7;
            }
            a3[a4 - 1] = a5;
        }
        return new UpperTriangularMatrix(a3);
    }
}

