/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.EigenvalueExtracter;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.HessenbergReduction4SymmetricMatrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithmSkeleton;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.SchurTransformation4TridiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.GivensMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricQRAlgorithm
implements Spectrum {
    private final QRAlgorithmSkeleton.Result enum;

    public SymmetricQRAlgorithm(Matrix A2, double epsilon, int maxIterations) {
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, epsilon), "symmetric QR algorithm applies only to symmetric matrix", new Object[0]);
        QRAlgorithmSkeleton a2 = new QRAlgorithmSkeleton(new HessenbergReduction4SymmetricMatrix(), new SchurTransformation4TridiagonalMatrix(epsilon, maxIterations), new EigenvalueExtracter(){

            @Override
            public List<? extends Number> extract(Matrix D2) {
                int a2 = D2.nRows();
                ArrayList<Double> a3 = new ArrayList<Double>(a2);
                for (int a4 = 1; a4 <= a2; ++a4) {
                    a3.add(D2.get(a4, a4));
                }
                return a3;
            }
            {
                1 a3;
            }
        });
        Matrix a3 = A2 instanceof SymmetricMatrix ? A2 : new SymmetricMatrix(A2);
        this.enum = a2.process(a3);
    }

    public Matrix Q() {
        return this.enum.Q();
    }

    public SymmetricQRAlgorithm(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2), Integer.MAX_VALUE);
    }

    public List<Vector> getEigenvectors() {
        Matrix a2 = this.Q();
        int a3 = a2.nCols();
        ArrayList<Vector> a4 = new ArrayList<Vector>(a3);
        for (int a5 = 1; a5 <= a3; ++a5) {
            a4.add(a2.getColumn(a5));
        }
        return a4;
    }

    public List<Double> getEigenvalues() {
        List<? extends Number> a2 = this.enum.getEigenvalues();
        return a2;
    }

    public Matrix D() {
        return this.enum.T();
    }

    public SymmetricQRAlgorithm(Matrix A2, double epsilon) {
        this(A2, epsilon, Integer.MAX_VALUE);
    }

    public List<GivensMatrix> Gs() {
        SchurTransformation4TridiagonalMatrix.SchurDecomposition4TridiagonalMatrix a2 = (SchurTransformation4TridiagonalMatrix.SchurDecomposition4TridiagonalMatrix)this.enum.getRealSchurCanonicalFormDecomposition();
        return a2.Gs();
    }
}

