/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HessenbergDecomposition {
    private volatile Matrix void = null;
    private final int class;
    private HouseholderInPlace goto;
    private Matrix enum;

    public Matrix H() {
        return this.enum.deepCopy();
    }

    public HessenbergDecomposition(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "Hessenberg Reduction applies only to square matrices", new Object[0]);
        this.class = A2.nRows();
        if (Hessenberg.isHessenberg(A2, 0.0)) {
            this.enum = A2.deepCopy();
            this.void = A2.ONE();
            return;
        }
        this.goto = new HouseholderInPlace(A2);
        int a2 = this.class - 2;
        for (int a3 = 1; a3 <= a2; ++a3) {
            HouseholderInPlace.Householder a4 = this.goto.generateAndReflectColumns(a3, this.class, a3 + 1, this.class);
            this.goto.rightReflect(a4, 1, this.class);
        }
        this.enum = this.goto.getTransformedMatrix();
    }

    public Matrix Q() {
        if (this.void == null) {
            this.void = this.goto.U().t();
        }
        return this.void.deepCopy();
    }
}

