/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalization;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiDiagonalizationByHouseholder
implements BiDiagonalization {
    private final int class;
    private final int goto;
    private final HouseholderInPlace enum;

    @Override
    public Matrix V() {
        return this.enum.Vt().t();
    }

    @Override
    public BidiagonalMatrix B() {
        BidiagonalMatrix a2 = new BidiagonalMatrix(this.class, BidiagonalMatrix.BidiagonalMatrixType.UPPER);
        for (int a3 = 1; a3 <= this.class - 1; ++a3) {
            a2.set(a3, a3, this.enum.get(a3, a3));
            a2.set(a3, a3 + 1, this.enum.get(a3, a3 + 1));
        }
        a2.set(this.class, this.class, this.enum.get(this.class, this.class));
        return a2;
    }

    public BiDiagonalizationByHouseholder(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isTall(A2), "Bi-diagonalization applies only to tall matrices", new Object[0]);
        this.goto = A2.nRows();
        this.class = A2.nCols();
        this.enum = new HouseholderInPlace(A2);
        if (this.class == 1) {
            this.enum.generateAndReflectColumns(1, this.class, 1, this.goto);
        } else {
            int a2 = this.class - 2;
            for (int a3 = 1; a3 <= a2; ++a3) {
                this.enum.generateAndReflectColumns(a3, this.class, a3, this.goto);
                this.enum.generateAndReflectRows(a3, this.goto, a3 + 1, this.class);
            }
            this.enum.generateAndReflectColumns(this.class - 1, this.class, this.class - 1, this.goto);
            if (this.goto != this.class) {
                this.enum.generateAndReflectColumns(this.class, this.class, this.class, this.goto);
            }
        }
    }

    @Override
    public Matrix U() {
        return this.enum.U().t();
    }
}

