/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPSelfFinancing
extends SOCPPortfolioConstraint {
    private final Vector class;
    private final double goto;
    private final int enum;

    @Override
    public int dimensionOfDomain() {
        return this.class.size();
    }

    public SOCPSelfFinancing(Vector w_0) {
        this(w_0, 0.01);
    }

    public double bias(Vector y) {
        double a2 = 0.0;
        for (int a3 = 1; a3 <= this.enum; ++a3) {
            a2 += y.get(a3) - this.class.get(a3);
        }
        return a2;
    }

    public SOCPSelfFinancing(Vector w_0, double epsilon) {
        this.class = w_0;
        this.enum = w_0.size();
        this.goto = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.enum));
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 0; a4 < this.enum; ++a4) {
            a3.add(new SparseMatrix.Entry(new MatrixCoordinate(1, a4 + 1), 1.0));
        }
        CSRSparseMatrix a5 = new CSRSparseMatrix(1, this.enum, a3);
        double a6 = 0.0;
        for (int a7 = 1; a7 <= this.enum; ++a7) {
            a6 -= w_0.get(a7);
        }
        SparseVector a8 = new SparseVector(a6);
        SparseVector a9 = new SparseVector(this.enum);
        double a10 = 0.0;
        a2.add(new SOCPGeneralConstraint(a5.t(), a8, a9, a10));
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        double a2 = this.evaluate(y);
        if (DoubleUtils.compare(a2, 0.0, this.goto) != 0) {
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("portfolio not self financing: %f, %s", a2, y.toString()));
        }
        return true;
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    @Override
    public Double evaluate(Vector y) {
        double a2 = this.bias(y);
        return a2;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }
}

