/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPNoTradingList1
extends SOCPPortfolioConstraint {
    private final Matrix void;
    private final int class;
    private final double goto;
    private final int enum;

    public SOCPNoTradingList1(Vector w_0, Matrix D_BL0, double epsilon) {
        this.class = w_0.size();
        this.enum = w_0.size();
        this.void = D_BL0;
        this.goto = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.enum));
        ArrayList<SparseMatrix.Entry> a3 = new ArrayList<SparseMatrix.Entry>();
        for (int a4 = 1; a4 <= this.enum; ++a4) {
            a3.add(new SparseMatrix.Entry(new MatrixCoordinate(a4, a4), this.void.get(a4, a4)));
        }
        CSRSparseMatrix a5 = new CSRSparseMatrix(this.enum, this.enum, a3);
        ArrayList<SparseVector.Entry> a6 = new ArrayList<SparseVector.Entry>();
        for (int a7 = 1; a7 <= this.enum; ++a7) {
            a6.add(new SparseVector.Entry(a7, -this.void.get(a7, a7) * w_0.get(a7)));
        }
        SparseVector a8 = new SparseVector(this.enum, a6);
        SparseVector a9 = new SparseVector(this.enum);
        double a10 = 0.0;
        a2.add(new SOCPGeneralConstraint(a5.t(), a8, a9, a10));
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        double a2 = this.evaluate(y);
        int a3 = DoubleUtils.compare(a2, 0.0, this.goto);
        if (a3 != 0) {
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("non-zero position for a black listed asset: %f", a2));
        }
        return true;
    }

    public SOCPNoTradingList1(Vector w_0, Matrix D_BL0) {
        this(w_0, D_BL0, 0.01);
    }

    @Override
    public int dimensionOfDomain() {
        return this.class;
    }

    public SOCPNoTradingList1(Vector w_0, Vector bl) {
        this(w_0, new DiagonalMatrix(bl.toArray()));
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = 0.0;
        int a3 = 0;
        for (int a4 = 1; a4 <= this.enum; ++a4) {
            if (!(this.void.get(a4, a4) > 0.0)) continue;
            a2 += Math.abs(x.get(a4));
            ++a3;
        }
        double a5 = a3 > 0 ? a2 / (double)a3 : 0.0;
        return a5;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }
}

