/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraint;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPGeneralConstraints;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPMaximumLoan
extends SOCPPortfolioConstraint {
    private final double void;
    private final int class;
    private final Vector goto;
    private final Vector enum;

    @Override
    public Double evaluate(Vector y) {
        Vector a2 = y.minus(this.goto);
        double a3 = 0.0;
        for (int a4 = 1; a4 <= this.class; ++a4) {
            double a5 = a2.get(a4) + Math.max(0.0, this.goto.get(a4));
            double a6 = a5 - this.enum.get(a4);
            a3 += a6;
        }
        return a3;
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        for (int a2 = 1; a2 <= this.class; ++a2) {
            double a3 = y.get(a2) + Math.max(0.0, this.goto.get(a2));
            double a4 = a3 - this.enum.get(a2);
            if (DoubleUtils.compare(a4, 0.0, this.void) >= 0) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("borrowing more than allowed: %f, %s", a4, y.toString()));
        }
        return true;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public int dimensionOfDomain() {
        return this.goto.size();
    }

    public SOCPMaximumLoan(Vector w_0, Vector l2) {
        this(w_0, l2, 0.01);
    }

    public SOCPMaximumLoan(Vector w_0, Vector l2, double epsilon) {
        this.goto = w_0;
        this.class = w_0.size();
        this.enum = l2;
        this.void = epsilon;
        SOCPGeneralConstraints a2 = this.newSOCPGeneralConstraints(new SOCPPortfolioConstraint.Variable("y", this.class));
        for (int a3 = 1; a3 <= this.class; ++a3) {
            CSRSparseMatrix a4 = new CSRSparseMatrix(1, this.class);
            SparseVector a5 = new SparseVector(1);
            SparseVector a6 = new SparseVector(this.class, new int[]{a3}, new double[]{1.0});
            double a7 = (Math.abs(w_0.get(a3)) - w_0.get(a3)) / 2.0 - l2.get(a3);
            a2.add(new SOCPGeneralConstraint(a4.t(), a5, a6, a7));
        }
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }
}

