/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.socp.constraints;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.CSRSparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.MatrixCoordinate;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearEqualities;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.SOCPLinearEquality;
import dev.nm.solver.multivariate.constrained.convex.sdp.socp.problem.portfoliooptimization.SOCPPortfolioConstraint;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SOCPLinearSectorNeutrality
extends SOCPPortfolioConstraint {
    private final double void;
    public static final double DEFAULT_EPSILON = 1.0E-6;
    private final int class;
    private final int goto;
    private final Vector[] enum;

    @Override
    public int dimensionOfDomain() {
        return this.class;
    }

    @Override
    public Double evaluate(Vector y) {
        double a2 = 0.0;
        for (int a3 = 0; a3 < this.goto; ++a3) {
            double a4 = y.innerProduct(this.enum[a3]);
            a2 += a4;
        }
        return a2;
    }

    public SOCPLinearSectorNeutrality(Vector[] S, double epsilon) {
        ArgumentAssertion.assertPositive(S.length, "S.length");
        this.enum = S;
        this.class = S[0].size();
        this.goto = S.length;
        IntStream.range(0, this.goto).forEach(a3 -> {
            SOCPLinearSectorNeutrality a4;
            ArgumentAssertion.assertTrue(S[a3].size() == a4.class, "S[%d] is not of the same size (%d)", a3, a4.class);
        });
        this.void = epsilon;
        SOCPLinearEqualities a2 = this.newSOCPLinearEqualities(new SOCPPortfolioConstraint.Variable("y", this.class));
        List<SparseMatrix.Entry> a4 = IntStream.rangeClosed(1, this.goto).boxed().flatMap(a6 -> {
            SOCPLinearSectorNeutrality a7;
            return IntStream.rangeClosed(1, a7.class).filter(a5 -> DoubleUtils.compare(S[a6 - 1].get(a5), 1.0, epsilon) == 0).mapToObj(a3 -> new SparseMatrix.Entry(new MatrixCoordinate(a3, (int)a6), 1.0));
        }).collect(Collectors.toList());
        CSRSparseMatrix a5 = new CSRSparseMatrix(this.class, this.goto, a4);
        SparseVector a7 = new SparseVector(this.goto);
        a2.add(new SOCPLinearEquality(a5, a7));
    }

    @Override
    public int dimensionOfRange() {
        return 1;
    }

    static {
        Package.validate("ALGOQUANT_SOCP_CONSTRAINTS");
    }

    @Override
    public boolean areAllConstraintsSatisfied(Vector y) throws SOCPPortfolioConstraint.ConstraintViolationException {
        for (int a2 = 0; a2 < this.goto; ++a2) {
            double a3 = y.innerProduct(this.enum[a2]);
            if (DoubleUtils.isZero(a3, this.void)) continue;
            throw new SOCPPortfolioConstraint.ConstraintViolationException(String.format("the %d-th sector neutrality is violated: %s", a2, y));
        }
        return true;
    }

    public SOCPLinearSectorNeutrality(Vector[] S) {
        this(S, 1.0E-6);
    }
}

